/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml
extends AInterface<File> {
    public static final String sOutSentDirectory = "sent";
    public static final String sOutFailedDirectory = "failed";
    public static final String sOutBrokenDirectory = "broken";
    private static final SimpleDateFormat fileSdf = new SimpleDateFormat("yyyyMMddHHmmss-S");
    private static final SimpleDateFormat iso8601Sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private File inDirectory;
    private File outDirectory;
    private File outFailedDirectory;
    private File outSentDirectory;
    private File outBrokenDirectory;

    protected String getDateAsISO8601(Date date) {
        String result = iso8601Sdf.format(date);
        StringBuilder sb = new StringBuilder(result.length() + 1);
        sb.append(result.substring(0, result.length() - 2));
        sb.append(":");
        sb.append(result.substring(result.length() - 2));
        return sb.toString();
    }

    protected Date getISO8601AsDate(String string) {
        StringBuilder sb = new StringBuilder(string);
        sb.replace(string.length() - 3, string.length() - 2, "");
        try {
            return iso8601Sdf.parse(sb.toString());
        }
        catch (ParseException e) {
            this.logWarn("Can't parse " + string + " as ISO8601 date!");
            return null;
        }
    }

    public Xml(String myInterfaceId, Properties myProps, SMSServer myServer, AInterface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Interface for xml input/output files");
        this.inDirectory = new File(this.getProperty("in") == null ? "." : this.getProperty("in"));
        this.outDirectory = new File(this.getProperty("out") == null ? "." : this.getProperty("out"));
        if (this.isInbound()) {
            if (!this.inDirectory.isDirectory() || !this.inDirectory.canWrite()) {
                throw new IllegalArgumentException(myInterfaceId + ".in isn't a directory or isn't write-/readable!");
            }
            try {
                this.writeInboundDTD(this.inDirectory);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.isOutbound()) {
            if (!(this.outDirectory.isDirectory() && this.outDirectory.canRead() && this.outDirectory.canWrite())) {
                throw new IllegalArgumentException(myInterfaceId + ".out isn't a directory or isn't write-/readable!");
            }
            this.outSentDirectory = new File(this.outDirectory, sOutSentDirectory);
            if (!this.outSentDirectory.isDirectory() && !this.outSentDirectory.mkdir()) {
                throw new IllegalArgumentException("Can't create directory '" + this.outSentDirectory);
            }
            this.outFailedDirectory = new File(this.outDirectory, sOutFailedDirectory);
            if (!this.outFailedDirectory.isDirectory() && !this.outFailedDirectory.mkdir()) {
                throw new IllegalArgumentException("Can't create directory '" + this.outFailedDirectory);
            }
            this.outBrokenDirectory = new File(this.outDirectory, sOutBrokenDirectory);
            if (!this.outBrokenDirectory.isDirectory() && !this.outBrokenDirectory.mkdir()) {
                throw new IllegalArgumentException("Can't create directory '" + this.outBrokenDirectory);
            }
            try {
                this.writeOutboundDTD(this.outDirectory);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void writeInboundDTD(File in) throws IOException {
        File dtd = new File(in, "smssvr_in.dtd");
        if (!dtd.exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(dtd));
            String CRLF = System.getProperty("line.separator");
            w.write(" <!ELEMENT message (originator, text, receive_date)>");
            w.write(CRLF);
            w.write("   <!ATTLIST message");
            w.write(CRLF);
            w.write("       id\t\tID\t#REQUIRED");
            w.write(CRLF);
            w.write("       gateway_id\tCDATA\t#REQUIRED");
            w.write(CRLF);
            w.write("       type\t\tCDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("       encoding\tCDATA\t#IMPLIED >");
            w.write(CRLF);
            w.write("     <!ELEMENT originator (#PCDATA)>");
            w.write(CRLF);
            w.write("     <!ELEMENT text (#PCDATA)>");
            w.write(CRLF);
            w.write("     <!ELEMENT receive_date (#PCDATA)>");
            w.write(CRLF);
            ((Writer)w).flush();
            ((Writer)w).close();
        }
    }

    private void writeOutboundDTD(File out) throws IOException {
        File dtd = new File(out, "smssvr_out.dtd");
        if (!dtd.exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(dtd));
            String CRLF = System.getProperty("line.separator");
            w.write(" <!ELEMENT message (recipient, text, originator, create_date?)>");
            w.write(CRLF);
            w.write("   <!ATTLIST message ");
            w.write(CRLF);
            w.write("      id\t \t ID      #REQUIRED");
            w.write(CRLF);
            w.write("      gateway_id\t CDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("      status         CDATA  \"U\" ");
            w.write(CRLF);
            w.write("      encoding       CDATA\t\"7\"");
            w.write(CRLF);
            w.write("      priority       CDATA\t\"N\"");
            w.write(CRLF);
            w.write("      ref_no         CDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("      status_report  CDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("      flash_sms      CDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("      src_port       CDATA\t#IMPLIED");
            w.write(CRLF);
            w.write("      dst_port       CDATA\t#IMPLIED> ");
            w.write(CRLF);
            w.write("   <!ELEMENT recipient (#PCDATA)>");
            w.write(CRLF);
            w.write("   <!ELEMENT text (#PCDATA)>");
            w.write(CRLF);
            w.write("   <!ELEMENT create_date (#PCDATA)>");
            w.write(CRLF);
            w.write("   <!ELEMENT originator (#PCDATA)>");
            w.write(CRLF);
            ((Writer)w).flush();
            ((Writer)w).close();
        }
    }

    private void addMessageToDocument(Document xmldoc, InboundMessage m) {
        Element message = null;
        Element originatorElement = null;
        Text originatorNode = null;
        Element textElement = null;
        Text textNode = null;
        Element timeElement = null;
        Text timeNode = null;
        message = xmldoc.createElement("message");
        message.setAttribute("gateway_id", m.getGatewayId());
        String msgType = null;
        switch (m.getType()) {
            case INBOUND: {
                msgType = "I";
                break;
            }
            case STATUSREPORT: {
                msgType = "S";
                break;
            }
            case OUTBOUND: {
                msgType = "O";
                break;
            }
            case UNKNOWN: {
                msgType = "U";
                break;
            }
            case WAPSI: {
                msgType = "W";
            }
        }
        if (msgType != null) {
            message.setAttributeNS(null, "type", msgType);
        }
        String encoding = null;
        switch (m.getEncoding()) {
            case ENC7BIT: {
                encoding = "7";
                break;
            }
            case ENC8BIT: {
                encoding = "8";
                break;
            }
            case ENCUCS2: {
                encoding = "U";
                break;
            }
            case ENCCUSTOM: {
                encoding = "C";
            }
        }
        if (encoding != null) {
            message.setAttributeNS(null, "encoding", encoding);
        }
        originatorNode = xmldoc.createTextNode(m.getOriginator());
        originatorElement = xmldoc.createElementNS(null, "originator");
        originatorElement.appendChild(originatorNode);
        textNode = xmldoc.createTextNode(m.getText());
        textElement = xmldoc.createElementNS(null, "text");
        textElement.appendChild(textNode);
        timeNode = xmldoc.createTextNode(this.getDateAsISO8601(m.getDate()));
        timeElement = xmldoc.createElementNS(null, "receive_date");
        timeElement.appendChild(timeNode);
        message.appendChild(originatorElement);
        message.appendChild(textElement);
        message.appendChild(timeElement);
        xmldoc.appendChild(message);
    }

    @Override
    public void CallReceived(String gtwId, String callerId) {
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        ArrayList<OutboundMessage> messageList = new ArrayList<OutboundMessage>();
        File[] outFiles = this.outDirectory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".xml") && !Xml.this.getMessageCache().containsValue(f);
            }
        });
        for (int i = 0; i < outFiles.length; ++i) {
            try {
                OutboundMessage msg = this.readDocument(outFiles[i]);
                if (msg == null) {
                    throw new IllegalArgumentException("Missing required fieldes!");
                }
                messageList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), outFiles[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.logWarn("Skipping outgoing file " + outFiles[i].getAbsolutePath() + ": File is not valid: " + e.getLocalizedMessage());
                File brokenFile = new File(this.outBrokenDirectory, outFiles[i].getName());
                if (outFiles[i].renameTo(brokenFile)) continue;
                this.logError("Can't move " + outFiles[i] + " to " + brokenFile);
            }
        }
        return messageList;
    }

    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        if (msg == null) {
            return;
        }
        File f = (File)this.getMessageCache().get(msg.getMessageId());
        File newF = null;
        switch (msg.getMessageStatus()) {
            case SENT: {
                newF = new File(this.outSentDirectory, f.getName());
                break;
            }
            case FAILED: {
                newF = new File(this.outFailedDirectory, f.getName());
                break;
            }
        }
        if (f.renameTo(newF)) {
            this.logInfo(f + " marked.");
        } else {
            this.logWarn("Can't move " + f + " to " + newF);
        }
        this.getMessageCache().remove(msg.getMessageId());
    }

    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        for (InboundMessage msg : msgList) {
            if (msg.getType() != Message.MessageTypes.INBOUND && msg.getType() != Message.MessageTypes.STATUSREPORT) continue;
            Document xmldoc = db.newDocument();
            this.addMessageToDocument(xmldoc, msg);
            String fileName = fileSdf.format(new Date()) + ".xml";
            this.logInfo("Writing inbound files to " + fileName);
            this.writeDocument(xmldoc, new File(this.inDirectory, fileName));
        }
    }

    private OutboundMessage readDocument(File file) throws IllegalArgumentException {
        Document xmldoc = null;
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            dbfac.setValidating(true);
            DocumentBuilder db = dbfac.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException arg0) {
                    throw new IllegalArgumentException(arg0);
                }

                public void fatalError(SAXParseException arg0) {
                    throw new IllegalArgumentException(arg0);
                }

                public void warning(SAXParseException arg0) {
                    throw new IllegalArgumentException(arg0);
                }
            });
            xmldoc = db.parse(file);
            DocumentType outDoctype = xmldoc.getDoctype();
            if (!"message".equals(outDoctype.getName())) {
                throw new IllegalArgumentException("Wrong DOCTYPE - Have to be message!");
            }
            if (!"smssvr_out.dtd".equals(outDoctype.getSystemId())) {
                throw new IllegalArgumentException("Wrong SystemId in DOCTYPE - Have to be smssvr_out.dtd!");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        NodeList rnl = xmldoc.getElementsByTagName("message");
        if (rnl == null || rnl.getLength() != 1) {
            throw new IllegalArgumentException("Wrong root element or root element count!");
        }
        return this.readNode(rnl.item(0));
    }

    private OutboundMessage readNode(Node n) {
        if ("message".equals(n.getNodeName())) {
            String priority;
            String recipient = null;
            String text = null;
            String originator = null;
            Element e = (Element)n;
            NodeList cnl = n.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Node en = cnl.item(i);
                if ("recipient".equals(cnl.item(i).getNodeName())) {
                    recipient = en.getTextContent();
                    continue;
                }
                if ("text".equals(cnl.item(i).getNodeName())) {
                    text = en.getTextContent();
                    continue;
                }
                if (!"originator".equals(cnl.item(i).getNodeName())) continue;
                originator = en.getTextContent();
            }
            OutboundMessage outMsg = new OutboundMessage(recipient, text);
            outMsg.setFrom(originator);
            if (!"".equals(e.getAttribute("create_date"))) {
                outMsg.setDate(this.getISO8601AsDate(e.getAttribute("create_date")));
            }
            if (!"".equals(e.getAttribute("gateway_id"))) {
                outMsg.setGatewayId(e.getAttribute("gateway_id"));
            }
            if ("L".equalsIgnoreCase(priority = e.getAttribute("priority"))) {
                outMsg.setPriority(OutboundMessage.MessagePriorities.LOW);
            } else if ("N".equalsIgnoreCase(priority)) {
                outMsg.setPriority(OutboundMessage.MessagePriorities.NORMAL);
            } else if ("H".equalsIgnoreCase(priority)) {
                outMsg.setPriority(OutboundMessage.MessagePriorities.HIGH);
            }
            String encoding = e.getAttribute("encoding");
            if ("7".equals(encoding)) {
                outMsg.setEncoding(Message.MessageEncodings.ENC7BIT);
            } else if ("8".equals(encoding)) {
                outMsg.setEncoding(Message.MessageEncodings.ENC8BIT);
            } else {
                outMsg.setEncoding(Message.MessageEncodings.ENCUCS2);
            }
            if ("1".equals(e.getAttribute("status_report"))) {
                outMsg.setStatusReport(true);
            }
            if ("1".equals(e.getAttribute("flash_sms"))) {
                outMsg.setFlashSms(true);
            }
            if (!"".equals(e.getAttribute("src_port"))) {
                outMsg.setSrcPort(Integer.parseInt(e.getAttribute("src_port")));
            }
            if (!"".equals(e.getAttribute("dst_port"))) {
                outMsg.setDstPort(Integer.parseInt(e.getAttribute("dst_port")));
            }
            return outMsg;
        }
        return null;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    private void writeDocument(Document doc, File fileName) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        FileOutputStream fos = new FileOutputStream(fileName);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("standalone", "yes");
        trans.setOutputProperty("encoding", "UTF-8");
        trans.setOutputProperty("doctype-system", "smssvr_in.dtd");
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        fos.close();
    }
}

