/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jmx
extends AInterface<Void> {
    private MBeanServer mbs;
    private SMSServerMethods ssm;
    private ObjectName obn;
    List<OutboundMessage> outboundMessages;
    List<InboundMessage> inboundMessages;
    List<OutboundMessage> markedOutboundMessages;

    public Jmx(String myInterfaceId, Properties myProps, SMSServer myServer, AInterface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("JMX based interface.");
        this.ssm = new SMSServerMethods();
        this.outboundMessages = new Vector<OutboundMessage>();
        this.inboundMessages = new Vector<InboundMessage>();
        this.markedOutboundMessages = new Vector<OutboundMessage>();
    }

    @Override
    public void CallReceived(String gtwId, String callerId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        List<InboundMessage> list = this.inboundMessages;
        synchronized (list) {
            this.inboundMessages.addAll(msgList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        List<OutboundMessage> list = this.outboundMessages;
        synchronized (list) {
            Vector<OutboundMessage> retValue = new Vector<OutboundMessage>();
            retValue.addAll(this.outboundMessages);
            this.outboundMessages.clear();
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        List<OutboundMessage> list = this.markedOutboundMessages;
        synchronized (list) {
            this.markedOutboundMessages.add(msg);
        }
    }

    @Override
    public void start() throws Exception {
        LocateRegistry.createRegistry(Integer.parseInt(this.getProperty("registry_port")));
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        JMXServiceURL url = new JMXServiceURL(this.getProperty("url"));
        JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
        connectorServer.start();
        this.obn = new ObjectName(this.getProperty("object_name"));
        this.mbs.registerMBean(this.ssm, this.obn);
        this.logInfo("Bound JMX to " + url);
    }

    @Override
    public void stop() throws Exception {
        if (this.mbs != null) {
            this.mbs.unregisterMBean(this.obn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SMSServerMethods
    implements SMSServerMethodsMBean {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOutboundMessage(OutboundMessage msg) {
            List<OutboundMessage> list = Jmx.this.outboundMessages;
            synchronized (list) {
                Jmx.this.outboundMessages.add(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOutboundMessage(Collection<OutboundMessage> msgs) {
            List<OutboundMessage> list = Jmx.this.outboundMessages;
            synchronized (list) {
                Jmx.this.outboundMessages.addAll(msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<InboundMessage> getInboundMessages() {
            List<InboundMessage> list = Jmx.this.inboundMessages;
            synchronized (list) {
                Vector<InboundMessage> retValue = new Vector<InboundMessage>();
                retValue.addAll(Jmx.this.inboundMessages);
                Jmx.this.inboundMessages.clear();
                return retValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<OutboundMessage> getMarkedOutboundMessages() {
            List<OutboundMessage> list = Jmx.this.markedOutboundMessages;
            synchronized (list) {
                Vector<OutboundMessage> retValue = new Vector<OutboundMessage>();
                retValue.addAll(Jmx.this.markedOutboundMessages);
                Jmx.this.markedOutboundMessages.clear();
                return retValue;
            }
        }

        @Override
        public int getGatewayQueueLoad() {
            return Jmx.this.getService().getGatewayQueueLoad();
        }

        @Override
        public int getInboundMessageCount() {
            return Jmx.this.getService().getInboundMessageCount();
        }

        @Override
        public int getOutboundMessageCount() {
            return Jmx.this.getService().getOutboundMessageCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SMSServerMethodsMBean {
        public void addOutboundMessage(OutboundMessage var1);

        public void addOutboundMessage(Collection<OutboundMessage> var1);

        public Collection<InboundMessage> getInboundMessages();

        public Collection<OutboundMessage> getMarkedOutboundMessages();

        public int getGatewayQueueLoad();

        public int getInboundMessageCount();

        public int getOutboundMessageCount();
    }
}

