/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Http
extends AInterface<Integer> {
    public Http(String myInterfaceId, Properties myProps, SMSServer myServer, AInterface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default http interface.");
    }

    @Override
    public void start() throws Exception {
        this.logInfo("SMSServer: Interface HTTP started.");
    }

    @Override
    public void stop() throws Exception {
        this.logInfo("SMSServer: Interface HTTP stopped.");
    }

    @Override
    public void CallReceived(String gtwId, String callerId) throws Exception {
    }

    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        String template = this.getProperty("get_url");
        this.logInfo("SMSServer: Interface HTTP: " + template);
        for (InboundMessage im : msgList) {
            if (im.getType() != Message.MessageTypes.INBOUND && im.getType() != Message.MessageTypes.STATUSREPORT) continue;
            String getURL = this.updateInboundTemplateString(template, im);
            this.logInfo("SMSServer: Interface HTTP: " + getURL);
            URL url = new URL(getURL);
            this.HttpGet(url);
        }
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        return new ArrayList<OutboundMessage>();
    }

    @Override
    public void markMessage(OutboundMessage om) throws Exception {
        String template = this.getProperty("dlr_url");
        String dlrURL = this.updateOutboundTemplateString(template, om);
        URL url = new URL(dlrURL);
        this.HttpGet(url);
        this.getMessageCache().remove(om.getId());
    }

    List<String> HttpGet(URL url) throws IOException {
        String inputLine;
        ArrayList<String> responseList = new ArrayList<String>();
        this.logInfo("HTTP GET: " + url);
        URLConnection con = url.openConnection();
        con.setAllowUserInteraction(false);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            responseList.add(inputLine);
        }
        in.close();
        return responseList;
    }

    private String updateInboundTemplateString(String template, InboundMessage msg) throws UnsupportedEncodingException {
        ExtStringBuilder sb = new ExtStringBuilder(template);
        sb.replaceAll("%gatewayId%", URLEncoder.encode(msg.getGatewayId(), "ISO-8859-1"));
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        sb.replaceAll("%date%", URLEncoder.encode(msg.getDate().toString(), "ISO-8859-1"));
        sb.replaceAll("%text%", URLEncoder.encode(msg.getText(), "ISO-8859-1"));
        sb.replaceAll("%pduUserData%", URLEncoder.encode(msg.getPduUserData(), "ISO-8859-1"));
        sb.replaceAll("%originator%", msg.getOriginator());
        sb.replaceAll("%memIndex%", msg.getMemIndex());
        sb.replaceAll("%mpMemIndex%", msg.getMpMemIndex());
        return sb.toString();
    }

    private String updateOutboundTemplateString(String template, OutboundMessage msg) throws UnsupportedEncodingException {
        ExtStringBuilder sb = new ExtStringBuilder(template);
        sb.replaceAll("%gatewayId%", URLEncoder.encode(msg.getGatewayId(), "ISO-8859-1"));
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        sb.replaceAll("%date%", URLEncoder.encode(msg.getDate().toString(), "ISO-8859-1"));
        sb.replaceAll("%text%", URLEncoder.encode(msg.getText(), "ISO-8859-1"));
        sb.replaceAll("%refNo%", URLEncoder.encode(msg.getRefNo(), "ISO-8859-1"));
        sb.replaceAll("%recipient%", msg.getRecipient());
        sb.replaceAll("%from%", msg.getFrom());
        sb.replaceAll("%failureCause%", URLEncoder.encode(msg.getFailureCause().toString(), "ISO-8859-1"));
        sb.replaceAll("%messageStatus%", msg.getMessageStatus().toString());
        return sb.toString();
    }

    private class ExtStringBuilder {
        final StringBuilder sb;

        public ExtStringBuilder() {
            this.sb = new StringBuilder();
        }

        public ExtStringBuilder(String str) {
            this.sb = new StringBuilder(str);
        }

        public ExtStringBuilder(StringBuilder mySb) {
            this.sb = mySb;
        }

        public void replaceAll(String search, int replace) {
            this.replaceAll(search, String.valueOf(replace));
        }

        public void replaceAll(String search, String replace) {
            int length = search.length();
            int start = this.sb.indexOf(search);
            while (start != -1) {
                this.sb.replace(start, start + length, replace);
                start = this.sb.indexOf(search);
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

