/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
extends AInterface<Void> {
    private Session mailSession;
    private String messageSubject;
    private String messageBody;

    public Email(String myInterfaceId, Properties myProps, SMSServer myServer, AInterface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Interface for Email communication.");
    }

    @Override
    public void CallReceived(String gtwId, String callerId) {
    }

    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        for (InboundMessage im : msgList) {
            MimeMessage msg = new MimeMessage(this.mailSession);
            msg.setFrom();
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getProperty("to")));
            msg.setSubject(this.updateTemplateString(this.messageSubject, im));
            if (this.messageBody != null) {
                msg.setText(this.updateTemplateString(this.messageBody, im));
            } else {
                msg.setText(im.toString());
            }
            msg.setSentDate(im.getDate());
            Transport.send((Message)msg);
        }
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        ArrayList<OutboundMessage> retValue = new ArrayList<OutboundMessage>();
        Store s = this.mailSession.getStore();
        s.connect();
        Folder inbox = s.getFolder(this.getProperty("mailbox_name", "INBOX"));
        inbox.open(2);
        for (Message m : inbox.getMessages()) {
            OutboundMessage om = new OutboundMessage(m.getSubject(), m.getContent().toString());
            om.setFrom(m.getFrom().toString());
            om.setDate(m.getReceivedDate());
            retValue.add(om);
            m.setFlag(Flags.Flag.DELETED, true);
        }
        inbox.close(true);
        s.close();
        return retValue;
    }

    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        this.logWarn("NOOP!");
    }

    @Override
    public void start() throws Exception {
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.store.protocol", this.getProperty("mailbox_protocol"));
        if ("pop3".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.pop3.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.pop3.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.pop3.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.pop3.password", this.getProperty("mailbox_password"));
        } else if ("pop3s".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.pop3s.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.pop3s.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.pop3s.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.pop3s.password", this.getProperty("mailbox_password"));
        } else if ("imap".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.imap.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.imap.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.imap.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.imap.password", this.getProperty("mailbox_password"));
        } else if ("imaps".equals(this.getProperty("mailbox_protocol"))) {
            mailProps.setProperty("mail.imaps.host", this.getProperty("mailbox_host"));
            mailProps.setProperty("mail.imaps.port", this.getProperty("mailbox_port"));
            mailProps.setProperty("mail.imaps.user", this.getProperty("mailbox_user"));
            mailProps.setProperty("mail.imaps.password", this.getProperty("mailbox_password"));
        } else {
            throw new IllegalArgumentException("mailbox_protocol have to be pop3(s) or imap(s)!");
        }
        mailProps.setProperty("mail.transport.protocol", "smtp");
        mailProps.setProperty("mail.from", this.getProperty("from"));
        mailProps.setProperty("mail.smtp.host", this.getProperty("smtp_host"));
        mailProps.setProperty("mail.smtp.port", this.getProperty("smtp_port"));
        mailProps.setProperty("mail.smtp.user", this.getProperty("smtp_user"));
        mailProps.setProperty("mail.smtp.password", this.getProperty("smtp_password"));
        this.mailSession = Session.getInstance((Properties)mailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Email.this.getProperty("mailbox_user"), Email.this.getProperty("mailbox_password"));
            }
        });
        if (this.isOutbound()) {
            this.prepareEmailTemplate();
        }
    }

    private String updateTemplateString(String template, InboundMessage msg) {
        ExtStringBuilder sb = new ExtStringBuilder();
        sb.replaceAll("%gatewayId%", msg.getGatewayId());
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        sb.replaceAll("%date%", msg.getDate().toString());
        sb.replaceAll("%text%", msg.getText());
        sb.replaceAll("%pduUserData%", msg.getPduUserData());
        sb.replaceAll("%originator%", msg.getOriginator());
        sb.replaceAll("%memIndex%", msg.getMemIndex());
        sb.replaceAll("%mpMemIndex%", msg.getMpMemIndex());
        return sb.toString();
    }

    private void prepareEmailTemplate() {
        File f;
        this.messageSubject = this.getProperty("message_subject");
        if (this.messageSubject == null || this.messageSubject.length() == 0) {
            this.logWarn("No message_subject found - Using default");
            this.messageSubject = "SMS from %ORIGINATOR%";
        }
        if ((f = new File(this.getProperty("message_body"))).canRead()) {
            try {
                FileReader r = new FileReader(f);
                BufferedReader br = new BufferedReader(r);
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                this.messageBody = sb.toString();
            }
            catch (IOException e) {
                this.logError("I/O-Exception while reading message body template: " + e.getMessage());
            }
        }
        if (this.messageBody == null || this.messageBody.length() == 0) {
            this.logWarn("message_body can't be read or is empty - Using default");
            this.messageBody = null;
        }
    }

    @Override
    public void stop() throws Exception {
    }

    private class ExtStringBuilder {
        final StringBuilder sb;

        public ExtStringBuilder() {
            this.sb = new StringBuilder();
        }

        public ExtStringBuilder(StringBuilder mySb) {
            this.sb = mySb;
        }

        public void replaceAll(String search, int replace) {
            this.replaceAll(search, String.valueOf(replace));
        }

        public void replaceAll(String search, String replace) {
            int length = search.length();
            int start = this.sb.indexOf(search);
            while (start != -1) {
                this.sb.replace(start, start + length, replace);
                start = this.sb.indexOf(search);
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

