/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.StatusReportMessage;
import org.smslib.smsserver.AInterface;
import org.smslib.smsserver.SMSServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
extends AInterface<Integer> {
    public Database(String myInterfaceId, Properties myProps, SMSServer myServer, AInterface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default database interface.");
    }

    @Override
    public void start() throws Exception {
        Class.forName(this.getProperty("driver"));
        Connection con = this.getDbConnection();
        if (con != null) {
            Statement cmd = con.createStatement(1003, 1007);
            cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = 'U' where status = 'Q'");
            con.commit();
            cmd.close();
            con.close();
        }
        this.logInfo("SMSServer: Interface Database started.");
    }

    @Override
    public void stop() throws Exception {
        Connection con = this.getDbConnection();
        if (con != null) {
            Statement cmd = con.createStatement(1003, 1007);
            cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "smsserver_out") + " set status = 'U' where status = 'Q'");
            con.commit();
            cmd.close();
            con.close();
        }
        this.logInfo("SMSServer: Interface Database started.");
    }

    @Override
    public void CallReceived(String gtwId, String callerId) throws Exception {
        Connection con = this.getDbConnection();
        Statement cmd = con.createStatement(1005, 1008);
        ResultSet rs = cmd.executeQuery("select * from " + this.getProperty("tables.calls", "smsserver_calls") + " where id = -1");
        rs.moveToInsertRow();
        rs.updateTimestamp("call_date", new Timestamp(new Date().getTime()));
        rs.updateString("gateway_id", gtwId);
        rs.updateString("caller_id", callerId);
        rs.insertRow();
        con.commit();
        rs.close();
        cmd.close();
        con.close();
    }

    @Override
    public void MessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        Connection con = this.getDbConnection();
        Statement cmd = con.createStatement(1003, 1008);
        ResultSet rs = cmd.executeQuery("select * from " + this.getProperty("tables.sms_in", "smsserver_in") + " where id = -1");
        for (InboundMessage msg : msgList) {
            if (msg.getType() != Message.MessageTypes.INBOUND && msg.getType() != Message.MessageTypes.STATUSREPORT) continue;
            rs.moveToInsertRow();
            rs.updateInt("process", 0);
            switch (msg.getEncoding()) {
                case ENC7BIT: {
                    rs.updateString("encoding", "7");
                    break;
                }
                case ENC8BIT: {
                    rs.updateString("encoding", "8");
                    break;
                }
                case ENCUCS2: {
                    rs.updateString("encoding", "U");
                    break;
                }
                case ENCCUSTOM: {
                    rs.updateString("encoding", "C");
                }
            }
            switch (msg.getType()) {
                case INBOUND: {
                    rs.updateString("type", "I");
                    rs.updateString("originator", msg.getOriginator());
                    if (msg.getDate() != null) {
                        rs.updateTimestamp("message_date", new Timestamp(msg.getDate().getTime()));
                    }
                    rs.updateString("original_ref_no", null);
                    rs.updateTimestamp("original_receive_date", null);
                    break;
                }
                case STATUSREPORT: {
                    rs.updateString("type", "S");
                    rs.updateString("originator", ((StatusReportMessage)msg).getRecipient());
                    if (((StatusReportMessage)msg).getSent() != null) {
                        rs.updateTimestamp("message_date", new Timestamp(((StatusReportMessage)msg).getSent().getTime()));
                    }
                    rs.updateString("original_ref_no", ((StatusReportMessage)msg).getRefNo());
                    if (((StatusReportMessage)msg).getReceived() != null) {
                        rs.updateTimestamp("original_receive_date", new Timestamp(((StatusReportMessage)msg).getReceived().getTime()));
                    }
                    if (!this.getProperty("update_outbound_on_statusreport", "no").equalsIgnoreCase("yes")) break;
                    Statement cmd2 = con.createStatement(1003, 1008);
                    ResultSet rs2 = cmd2.executeQuery("select status from " + this.getProperty("tables.sms_out", "smsserver_out") + " where recipient = '" + ((StatusReportMessage)msg).getRecipient() + "' and ref_no = '" + ((StatusReportMessage)msg).getRefNo() + "'");
                    if (rs2.next()) {
                        switch (((StatusReportMessage)msg).getStatus()) {
                            case DELIVERED: {
                                rs2.updateString("status", "D");
                                break;
                            }
                            case KEEPTRYING: {
                                rs2.updateString("status", "P");
                                break;
                            }
                            case ABORTED: {
                                rs2.updateString("status", "A");
                                break;
                            }
                        }
                        rs2.updateRow();
                    }
                    rs2.close();
                    cmd2.close();
                    break;
                }
            }
            rs.updateTimestamp("receive_date", new Timestamp(new Date().getTime()));
            rs.updateString("text", msg.getText().replaceAll("'", "''"));
            rs.updateString("gateway_id", msg.getGatewayId());
            rs.insertRow();
        }
        rs.close();
        cmd.close();
        con.commit();
        con.close();
    }

    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        int msgCount = 0;
        Connection con = this.getDbConnection();
        if (con != null) {
            Statement cmd = con.createStatement(1005, 1008);
            ResultSet rs = this.getProperty("type").equalsIgnoreCase("mysql") ? cmd.executeQuery("select * from " + this.getProperty("tables.sms_out", "smsserver_out") + " where status = 'U' order by priority, id") : cmd.executeQuery("select *, case when priority = 'H' then 1 when priority = 'N' then 2 when priority = 'L' then 3 else 4 end as prioritynum from " + this.getProperty("tables.sms_out", "smsserver_out") + " where status = 'U' order by prioritynum, id");
            while (rs.next()) {
                OutboundMessage msg = new OutboundMessage(rs.getString("recipient"), rs.getString("text"));
                if (rs.getString("priority").equalsIgnoreCase("L")) {
                    msg.setPriority(OutboundMessage.MessagePriorities.LOW);
                } else if (rs.getString("priority").equalsIgnoreCase("N")) {
                    msg.setPriority(OutboundMessage.MessagePriorities.NORMAL);
                } else if (rs.getString("priority").equalsIgnoreCase("H")) {
                    msg.setPriority(OutboundMessage.MessagePriorities.HIGH);
                }
                if (!this.getServer().checkPriorityTimeFrame(msg.getPriority())) continue;
                switch (rs.getString("encoding").charAt(0)) {
                    case '7': {
                        msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                        break;
                    }
                    case '8': {
                        msg.setEncoding(Message.MessageEncodings.ENC8BIT);
                        break;
                    }
                    case 'U': {
                        msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                    }
                }
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getInt("flash_sms") == 1) {
                    msg.setFlashSms(true);
                }
                if (rs.getInt("src_port") != -1) {
                    msg.setSrcPort(rs.getInt("src_port"));
                    msg.setDstPort(rs.getInt("dst_port"));
                }
                if (rs.getString("originator") != null) {
                    msg.setFrom(rs.getString("originator"));
                }
                msg.setGatewayId(rs.getString("gateway_id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                rs.updateString("status", "Q");
                rs.updateRow();
                con.commit();
                if (++msgCount <= Integer.parseInt(this.getProperty("batch_size"))) continue;
            }
            rs.close();
            cmd.close();
            con.close();
        }
        return msgList;
    }

    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        Connection con = null;
        ResultSet rs = null;
        Statement cmd = null;
        con = this.getDbConnection();
        cmd = con.createStatement(1005, 1008);
        rs = cmd.executeQuery("select * from " + this.getProperty("tables.sms_out", "smsserver_out") + " where id = " + this.getMessageCache().get(msg.getMessageId()));
        if (rs.next()) {
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                rs.updateString("status", "S");
                rs.updateTimestamp("sent_date", new Timestamp(msg.getDispatchDate().getTime()));
                rs.updateString("gateway_id", msg.getGatewayId());
                rs.updateString("ref_no", msg.getRefNo());
            } else if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                int errors = rs.getInt("errors");
                rs.updateInt("errors", ++errors);
                if (errors > Integer.parseInt(this.getProperty("retries", "2"))) {
                    rs.updateString("status", "F");
                } else {
                    rs.updateString("status", "U");
                }
            }
            rs.updateRow();
            con.commit();
            rs.close();
            cmd.close();
            con.close();
        }
        this.getMessageCache().remove(msg.getMessageId());
    }

    private Connection getDbConnection() {
        Connection dbCon = null;
        try {
            dbCon = DriverManager.getConnection(this.getProperty("url"), this.getProperty("username", ""), this.getProperty("password", ""));
            dbCon.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.logError("SMSServer: Database Interface: error!", e);
        }
        return dbCon;
    }
}

