/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.smslib.ICallNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.SMSLibException;
import org.smslib.Service;
import org.smslib.smsserver.AGateway;
import org.smslib.smsserver.AInterface;

public class SMSServer {
    Service srv = new Service();
    Properties props;
    boolean shutdown = false;
    List<AInterface<? extends Object>> infList = new ArrayList<AInterface<? extends Object>>();
    InboundNotification inboundNotification;
    OutboundNotification outboundNotification;
    CallNotification callNotification;
    InboundPollingThread inboundPollingThread;
    OutboundPollingThread outboundPollingThread;
    boolean optRunOnce = false;

    public SMSServer() {
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        this.inboundNotification = new InboundNotification();
        this.outboundNotification = new OutboundNotification();
        this.callNotification = new CallNotification();
        this.inboundPollingThread = null;
        this.outboundPollingThread = null;
    }

    public InboundNotification getInboundNotification() {
        return this.inboundNotification;
    }

    public OutboundNotification getOutboundNotification() {
        return this.outboundNotification;
    }

    public CallNotification getCallNotification() {
        return this.callNotification;
    }

    private void loadConfiguration() throws Exception {
        StringTokenizer tokens;
        String propValue;
        String propName;
        int i;
        FileInputStream f;
        this.props = new Properties();
        if (System.getProperty("smsserver.configdir") != null) {
            f = new FileInputStream(System.getProperty("smsserver.configdir") + "SMSServer.conf");
        } else if (System.getProperty("smsserver.configfile") != null) {
            f = new FileInputStream(System.getProperty("smsserver.configfile"));
        } else {
            throw new SMSLibException("Cannot find SMSServer configuration file!");
        }
        this.props.load(f);
        f.close();
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            try {
                propName = "gateway." + i;
                propValue = this.props.getProperty(propName, "");
                if (propValue.length() == 0) break;
                tokens = new StringTokenizer(propValue, ",");
                String gtwId = tokens.nextToken().trim();
                String gtwClass = tokens.nextToken().trim();
                Object[] args = new Object[]{gtwId, this.props, this};
                Class[] argsClass = new Class[]{String.class, Properties.class, SMSServer.class};
                Class<?> c = Class.forName("org.smslib.smsserver.gateways." + gtwClass);
                Constructor<?> constructor = c.getConstructor(argsClass);
                AGateway gtw = (AGateway)constructor.newInstance(args);
                gtw.create();
                this.srv.addGateway(gtw.gtw);
                this.srv.getLogger().info((Object)("SMSServer: added gateway " + gtwId + " / " + gtw.getDescription()));
                continue;
            }
            catch (Exception e) {
                this.srv.getLogger().error((Object)"SMSServer: Unknown Gateway in configuration file!");
            }
        }
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            try {
                propName = "interface." + i;
                propValue = this.props.getProperty(propName, "");
                if (propValue.length() == 0) break;
                tokens = new StringTokenizer(propValue, ",");
                String infId = tokens.nextToken().trim();
                String infClass = tokens.nextToken().trim();
                AInterface.InterfaceTypes infType = null;
                String sinfType = tokens.hasMoreTokens() ? tokens.nextToken() : "inoutbound";
                infType = "inbound".equalsIgnoreCase(sinfType = sinfType.trim()) ? AInterface.InterfaceTypes.INBOUND : ("outbound".equalsIgnoreCase(sinfType) ? AInterface.InterfaceTypes.OUTBOUND : AInterface.InterfaceTypes.INOUTBOUND);
                Object[] args = new Object[]{infId, this.props, this, infType};
                Class[] argsClass = new Class[]{String.class, Properties.class, SMSServer.class, AInterface.InterfaceTypes.class};
                Class<?> c = Class.forName("org.smslib.smsserver.interfaces." + infClass);
                Constructor<?> constructor = c.getConstructor(argsClass);
                AInterface inf = (AInterface)constructor.newInstance(args);
                this.infList.add(inf);
                this.srv.getLogger().info((Object)("SMSServer: added interface " + infId + " / " + inf.getDescription() + " / " + (Object)((Object)inf.getType())));
                continue;
            }
            catch (InvocationTargetException e) {
                this.srv.getLogger().error((Object)("SMSServer: Illegal Interface configuration: " + e.getCause().getMessage()));
                continue;
            }
            catch (Exception e) {
                this.srv.getLogger().error((Object)"SMSServer: Unknown Interface in configuration file!");
            }
        }
    }

    private void process() throws Exception {
        this.inboundPollingThread = new InboundPollingThread();
        this.inboundPollingThread.start();
        this.outboundPollingThread = new OutboundPollingThread();
        this.outboundPollingThread.start();
        while (!this.shutdown) {
            Thread.sleep(1000L);
        }
    }

    void startInterfaces() throws Exception {
        for (AInterface<? extends Object> inf : this.infList) {
            inf.start();
        }
    }

    void stopInterfaces() throws Exception {
        for (AInterface<? extends Object> inf : this.infList) {
            inf.stop();
        }
    }

    private void run() throws Exception {
        block3: {
            this.loadConfiguration();
            try {
                this.startInterfaces();
                this.srv.startService();
                this.process();
            }
            catch (Exception e) {
                this.stopInterfaces();
                this.srv.stopService();
                if (this.inboundPollingThread != null) {
                    this.inboundPollingThread.interrupt();
                    this.inboundPollingThread.join();
                }
                if (this.outboundPollingThread == null) break block3;
                this.outboundPollingThread.interrupt();
                this.outboundPollingThread.join();
            }
        }
    }

    void readMessages() throws Exception {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        this.srv.readMessages(msgList, InboundMessage.MessageClasses.ALL);
        if (msgList.size() > 0) {
            for (AInterface<? extends Object> inf : this.infList) {
                if (!inf.isInbound()) continue;
                inf.MessagesReceived(msgList);
            }
            if (this.props.getProperty("settings.delete_after_processing", "no").equalsIgnoreCase("yes")) {
                for (InboundMessage msg : msgList) {
                    this.srv.deleteMessage(msg);
                }
            }
        }
    }

    void sendMessages() throws Exception {
        boolean foundOutboundGateway = false;
        for (org.smslib.AGateway gtw : this.srv.getGatewayList()) {
            if (!gtw.isOutbound()) continue;
            foundOutboundGateway = true;
            break;
        }
        if (foundOutboundGateway) {
            ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
            for (AInterface<? extends Object> inf : this.infList) {
                if (!inf.isOutbound()) continue;
                msgList.addAll(inf.getMessagesToSend());
            }
            if (this.props.getProperty("settings.send_mode", "sync").equalsIgnoreCase("sync")) {
                this.srv.logInfo("SMSServer: sending synchronously...");
                this.srv.sendMessages(msgList);
                for (AInterface<? extends Object> inf : this.infList) {
                    if (!inf.isOutbound()) continue;
                    inf.markMessages(msgList);
                }
            } else {
                this.srv.logInfo("SMSServer: sending asynchronously...");
                this.srv.queueMessages(msgList);
            }
        }
    }

    public boolean checkPriorityTimeFrame(OutboundMessage.MessagePriorities priority) {
        Calendar cal = Calendar.getInstance();
        String timeFrame = priority == OutboundMessage.MessagePriorities.LOW ? this.props.getProperty("settings.timeframe.low", "0000-2359") : (priority == OutboundMessage.MessagePriorities.NORMAL ? this.props.getProperty("settings.timeframe.normal", "0000-2359") : (priority == OutboundMessage.MessagePriorities.HIGH ? this.props.getProperty("settings.timeframe.high", "0000-2359") : "0000-2359"));
        String from = timeFrame.substring(0, 4);
        String to = timeFrame.substring(5, 9);
        cal.setTime(new Date());
        String current = cal.get(11) < 10 ? "0" + cal.get(11) : "" + cal.get(11);
        current = current + (cal.get(12) < 10 ? "0" + cal.get(12) : "" + cal.get(12));
        return Integer.parseInt(current) >= Integer.parseInt(from) && Integer.parseInt(current) < Integer.parseInt(to);
    }

    public static void main(String[] args) {
        SMSServer app = new SMSServer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-runonce")) {
                app.optRunOnce = true;
                continue;
            }
            System.out.println("Invalid argument: " + args[i]);
        }
        try {
            app.run();
            app.srv.getLogger().info((Object)"SMSServer exiting normally.");
        }
        catch (Exception e) {
            app.srv.getLogger().fatal((Object)"SMSServer Error: ", (Throwable)e);
            try {
                app.srv.stopService();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CallNotification
    implements ICallNotification {
        CallNotification() {
        }

        public void process(String gtwId, String callerId) {
            try {
                for (AInterface<? extends Object> inf : SMSServer.this.infList) {
                    inf.CallReceived(gtwId, callerId);
                }
            }
            catch (Exception e) {
                SMSServer.this.srv.getLogger().fatal((Object)e);
            }
        }
    }

    class OutboundNotification
    implements IOutboundMessageNotification {
        OutboundNotification() {
        }

        public void process(String gtwId, OutboundMessage msg) {
            try {
                for (AInterface<? extends Object> inf : SMSServer.this.infList) {
                    if (!inf.isOutbound()) continue;
                    inf.markMessage(msg);
                }
            }
            catch (Exception e) {
                SMSServer.this.srv.getLogger().fatal((Object)e);
            }
        }
    }

    class InboundNotification
    implements IInboundMessageNotification {
        InboundNotification() {
        }

        public void process(String gtwId, Message.MessageTypes msgType, InboundMessage msg) {
            ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
            msgList.add(msg);
            for (AInterface<? extends Object> inf : SMSServer.this.infList) {
                if (!inf.isInbound()) continue;
                try {
                    inf.MessagesReceived(msgList);
                }
                catch (Exception e) {}
            }
            if (SMSServer.this.props.getProperty("settings.delete_after_processing", "no").equalsIgnoreCase("yes")) {
                try {
                    SMSServer.this.srv.deleteMessage(msg);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            msgList.clear();
        }
    }

    class OutboundPollingThread
    extends Thread {
        OutboundPollingThread() {
        }

        public void run() {
            try {
                while (!SMSServer.this.shutdown) {
                    SMSServer.this.srv.logDebug("OutboundPollingThread() run.");
                    SMSServer.this.sendMessages();
                    if (!SMSServer.this.optRunOnce) {
                        Thread.sleep(Integer.parseInt(SMSServer.this.props.getProperty("settings.outbound_interval", "60")) * 1000);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                SMSServer.this.srv.logDebug("OutboundPollingThread() interrupted.");
            }
            catch (Exception e) {
                SMSServer.this.srv.logDebug("Error in OutboundPollingThread()", e);
            }
        }
    }

    class InboundPollingThread
    extends Thread {
        InboundPollingThread() {
        }

        public void run() {
            try {
                while (!SMSServer.this.shutdown) {
                    SMSServer.this.srv.logDebug("InboundPollingThread() run.");
                    SMSServer.this.readMessages();
                    if (!SMSServer.this.optRunOnce) {
                        Thread.sleep(Integer.parseInt(SMSServer.this.props.getProperty("settings.inbound_interval", "60")) * 1000);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                SMSServer.this.srv.logDebug("InboundPollingThread() interrupted.");
            }
            catch (Exception e) {
                SMSServer.this.srv.logDebug("Error in InboundPollingThread()", e);
            }
        }
    }

    class Shutdown
    extends Thread {
        Shutdown() {
        }

        public void run() {
            SMSServer.this.srv.getLogger().info((Object)"SMSServer shutting down, please wait...");
            SMSServer.this.shutdown = true;
            try {
                SMSServer.this.stopInterfaces();
                SMSServer.this.srv.stopService();
                if (SMSServer.this.inboundPollingThread != null) {
                    SMSServer.this.inboundPollingThread.interrupt();
                    SMSServer.this.inboundPollingThread.join();
                }
                if (SMSServer.this.outboundPollingThread != null) {
                    SMSServer.this.outboundPollingThread.interrupt();
                    SMSServer.this.outboundPollingThread.join();
                }
            }
            catch (Exception e) {
                SMSServer.this.srv.getLogger().error((Object)e);
                e.printStackTrace();
            }
        }
    }
}

