/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.TimeoutException;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.CNMIDetector;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.AATHandler;

public class ATHandler
extends AATHandler {
    protected AModemDriver modemDriver;

    public AModemDriver getModemDriver() {
        return this.modemDriver;
    }

    public ATHandler(ModemGateway myGateway) {
        super(myGateway);
        this.modemDriver = myGateway.getModemDriver();
        this.terminators = new String[13];
        this.terminators[0] = "OK\\s";
        this.terminators[1] = "\\s*[\\p{ASCII}]*\\s+OK\\s";
        this.terminators[2] = "(ERROR|NO CARRIER|NO DIALTONE)\\s";
        this.terminators[3] = "ERROR:\\s*\\d+\\s";
        this.terminators[4] = "\\+CM[ES]\\s+ERROR:\\s*\\d+\\s";
        this.terminators[5] = "\\+CPIN:\\s*READY\\s";
        this.terminators[6] = "\\+CPIN:\\s*SIM\\s*BUSY\\s";
        this.terminators[7] = "\\+CPIN:\\s*SIM\\s*PIN\\s";
        this.terminators[8] = "\\+CPIN:\\s*SIM\\s*PIN2\\s";
        this.terminators[9] = "\\+CMTI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[10] = "\\+CDSI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[11] = "RING\\s";
        this.terminators[12] = "\\+CLIP:\\s*\\p{Punct}[\\p{ASCII}]*\\p{Punct}\\p{Punct}\\s*\\d+[\\p{ASCII}]*\\s";
    }

    public void sync() throws IOException, InterruptedException {
        this.getModemDriver().write("ATZ\r");
        Thread.sleep(this.getGateway().getService().S.AT_WAIT);
    }

    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("\u001b");
        Thread.sleep(this.getGateway().getService().S.AT_WAIT);
        this.getModemDriver().write("+++");
        Thread.sleep(this.getGateway().getService().S.AT_WAIT);
        this.getModemDriver().write("ATZ");
        Thread.sleep(this.getGateway().getService().S.AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    public void echoOff() throws IOException, InterruptedException {
        this.getModemDriver().write("ATE0\r");
        Thread.sleep(this.getGateway().getService().S.AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+COPS=0\r");
        this.getModemDriver().getResponse();
    }

    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    public boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN?\r");
        return this.getModemDriver().getResponse();
    }

    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN=\"_1_\"\r".replaceAll("_1_", pin));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMEE=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=0\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        while (true) {
            this.getModemDriver().write("AT+CNMI=?\r");
            try {
                CNMIDetector c = new CNMIDetector(this.getModemDriver().getResponse(), this.getGateway());
                this.getModemDriver().write(c.getATCommand());
                this.getModemDriver().getResponse();
                return this.getModemDriver().isOk();
            }
            catch (Exception e) {
                this.getGateway().logWarn("Retrying the detection of CNMI, modem busy?", e);
                Thread.sleep(this.getGateway().getService().S.AT_WAIT_CNMI);
                continue;
            }
            break;
        }
    }

    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMI\r");
        return this.getModemDriver().getResponse();
    }

    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMM\r");
        return this.getModemDriver().getResponse();
    }

    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse();
    }

    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CIMI\r");
        return this.getModemDriver().getResponse();
    }

    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMR\r");
        return this.getModemDriver().getResponse();
    }

    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC\r");
        return this.getModemDriver().getResponse();
    }

    public String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        return this.getModemDriver().getResponse();
    }

    public boolean switchStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("AT+CPMS=\"" + mem + "\"\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public void switchToCmdMode() throws IOException {
        this.getModemDriver().write("+++");
        Date start = new Date();
        while (new Date().getTime() - start.getTime() <= (long)this.getGateway().getService().S.AT_WAIT_CMD) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean keepGsmLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMMS=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public int sendMessage(int size, String pdu, String phone, String text) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int refNo;
        block14: {
            refNo = -1;
            if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
                int errorRetries = 0;
                while (true) {
                    int responseRetries = 0;
                    this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + size));
                    Thread.sleep(this.getGateway().getService().S.AT_WAIT_CGMS);
                    while (!this.getModemDriver().dataAvailable()) {
                        if (++responseRetries == this.getGateway().getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.getGateway().logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + responseRetries + ")...");
                        Thread.sleep(this.getGateway().getService().S.OUTBOUND_RETRY_WAIT);
                    }
                    responseRetries = 0;
                    this.getModemDriver().clearBuffer();
                    this.getModemDriver().write(pdu);
                    this.getModemDriver().write('\u001a');
                    String response = this.getModemDriver().getResponse();
                    while (response.length() == 0) {
                        if (++responseRetries == this.getGateway().getService().S.OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        this.getGateway().logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + responseRetries + ")...");
                        Thread.sleep(this.getGateway().getService().S.OUTBOUND_RETRY_WAIT);
                        response = this.getModemDriver().getResponse();
                    }
                    if (this.getModemDriver().getLastError() == 0) {
                        Matcher m = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(response);
                        refNo = m.find() ? Integer.parseInt(m.group(1)) : -1;
                        break block14;
                    }
                    if (this.getModemDriver().getLastError() > 0) {
                        if (++errorRetries == this.getGateway().getService().S.OUTBOUND_RETRIES) {
                            this.getGateway().logError(this.getModemDriver().getLastErrorText() + ": Quit retrying, message lost...");
                            refNo = -1;
                            break block14;
                        }
                        this.getGateway().logWarn(this.getModemDriver().getLastErrorText() + ": Retrying...");
                        Thread.sleep(this.getGateway().getService().S.OUTBOUND_RETRY_WAIT);
                        continue;
                    }
                    refNo = -1;
                }
            }
            if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT) {
                this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", phone));
                this.getModemDriver().clearBuffer();
                this.getModemDriver().write(text);
                Thread.sleep(this.getGateway().getService().S.AT_WAIT_CGMS);
                this.getModemDriver().write('\u001a');
                String response = this.getModemDriver().getResponse();
                if (response.indexOf("OK\r") >= 0) {
                    String tmp = "";
                    int i = response.indexOf(":");
                    while (!Character.isDigit(response.charAt(i))) {
                        ++i;
                    }
                    while (Character.isDigit(response.charAt(i))) {
                        tmp = tmp + response.charAt(i);
                        ++i;
                    }
                    refNo = Integer.parseInt(tmp);
                } else {
                    refNo = -1;
                }
            }
        }
        return refNo;
    }

    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=4\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=0\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=1\r");
            }
        } else if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
        }
        return this.getModemDriver().getResponse();
    }

    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!this.switchStorageLocation(memLocation)) {
            return false;
        }
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    public String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGATT?\r");
        return this.getModemDriver().getResponse();
    }

    public String send(String s) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write(s);
        return this.getModemDriver().getResponse();
    }

    public String getNetworkRegistration() throws GatewayException, TimeoutException, IOException {
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    public void readStorageLocations() throws Exception {
        this.getModemDriver().write("AT+CPMS?\r");
        String response = this.getModemDriver().getResponse();
        if (response.indexOf("+CPMS:") >= 0) {
            response = response.replaceAll("\\s*\\+CPMS:\\s*", "");
            StringTokenizer tokens = new StringTokenizer(response, ",");
            while (tokens.hasMoreTokens()) {
                String loc = tokens.nextToken().replaceAll("\"", "");
                if (this.getStorageLocations().indexOf(loc) < 0) {
                    this.addStorageLocation(loc);
                }
                tokens.nextToken();
                tokens.nextToken();
            }
        }
    }

    public AGateway.AsyncEvents processUnsolicitedEvents(String response) throws IOException {
        AGateway.AsyncEvents event = AGateway.AsyncEvents.NOTHING;
        if (response.indexOf("+CMTI") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDMESSAGE;
        } else if (response.indexOf("+CDSI") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE;
        } else if (response.indexOf("RING") >= 0) {
            event = AGateway.AsyncEvents.NOTHING;
        } else if (response.indexOf("+CLIP") >= 0) {
            event = AGateway.AsyncEvents.INBOUNDCALL;
        }
        return event;
    }
}

