/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.helper.CommPortIdentifier;
import org.smslib.helper.SerialPort;
import org.smslib.helper.SerialPortEvent;
import org.smslib.helper.SerialPortEventListener;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.ModemGateway;

class SerialModemDriver
extends AModemDriver
implements SerialPortEventListener {
    private String comPort;
    private int baudRate;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private ThreadReader threadReader;

    SerialModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.comPort = tokens.nextToken();
        this.baudRate = Integer.parseInt(tokens.nextToken());
        this.serialPort = null;
    }

    void connectPort() throws GatewayException, IOException, InterruptedException {
        if (this.gateway.getService().S.SERIAL_NOFLUSH) {
            this.gateway.logInfo("Comm port flushing is disabled.");
        }
        if (this.gateway.getService().S.SERIAL_POLLING) {
            this.gateway.logInfo("Using polled serial port mode.");
        }
        try {
            this.gateway.logInfo("Opening: " + this.comPort + " @" + this.baudRate);
            this.portId = CommPortIdentifier.getPortIdentifier(this.comPort);
            this.serialPort = this.portId.open("org.smslib", 1971);
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
            if (!this.gateway.getService().S.SERIAL_POLLING) {
                this.serialPort.notifyOnDataAvailable(true);
                this.serialPort.notifyOnOutputEmpty(true);
            }
            this.serialPort.notifyOnBreakInterrupt(true);
            this.serialPort.notifyOnFramingError(true);
            this.serialPort.notifyOnOverrunError(true);
            this.serialPort.notifyOnParityError(true);
            if (this.gateway.getService().S.SERIAL_RTSCTS_OUT) {
                this.serialPort.setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT);
            } else {
                this.serialPort.setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN);
            }
            this.serialPort.addEventListener(this);
            this.serialPort.setSerialPortParams(this.baudRate, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            this.serialPort.setInputBufferSize(this.gateway.getService().S.SERIAL_BUFFER_SIZE);
            this.serialPort.setOutputBufferSize(this.gateway.getService().S.SERIAL_BUFFER_SIZE);
            this.serialPort.enableReceiveThreshold(1);
            this.serialPort.enableReceiveTimeout(this.gateway.getService().S.SERIAL_TIMEOUT);
            if (this.gateway.getService().S.SERIAL_POLLING) {
                this.threadReader = new ThreadReader(this.gateway);
            }
        }
        catch (Exception e) {
            throw new GatewayException("Comm library exception: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectPort() throws IOException, InterruptedException {
        Object object = this.SYNC_Reader;
        synchronized (object) {
            if (this.gateway.getService().S.SERIAL_POLLING) {
                if (this.threadReader != null) {
                    this.threadReader.interrupt();
                    this.threadReader.join();
                }
                this.threadReader = null;
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            this.gateway.logInfo("Closing: " + this.comPort + " @" + this.baudRate);
        }
    }

    void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    boolean portHasData() throws IOException {
        return this.in.available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) {
        int eventType = event.getEventType();
        if (eventType == SerialPortEvent.OE) {
            this.gateway.logError("Overrun Error!");
        } else if (eventType == SerialPortEvent.FE) {
            this.gateway.logError("Framing Error!");
        } else if (eventType == SerialPortEvent.PE) {
            this.gateway.logError("Parity Error!");
        } else if (eventType == SerialPortEvent.DATA_AVAILABLE && !this.gateway.getService().S.SERIAL_POLLING) {
            Object object = this.SYNC_Reader;
            synchronized (object) {
                this.dataReceived = true;
                this.SYNC_Reader.notifyAll();
            }
        }
    }

    public void write(char c) throws IOException {
        this.out.write(c);
        if (!this.gateway.getService().S.SERIAL_NOFLUSH) {
            this.out.flush();
        }
    }

    public void write(byte[] s) throws IOException {
        this.out.write(s);
        if (!this.gateway.getService().S.SERIAL_NOFLUSH) {
            this.out.flush();
        }
    }

    int read() throws IOException {
        return this.in.read();
    }

    private class ThreadReader
    extends Thread {
        private AGateway gtw;

        public ThreadReader(AGateway myGtw) {
            this.gtw = myGtw;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.gtw.logDebug("ThreadReader started.");
            while (true) {
                try {
                    do {
                        ThreadReader.sleep(SerialModemDriver.this.gateway.getService().S.SERIAL_POLLING_INTERVAL);
                    } while (!SerialModemDriver.this.portHasData());
                    Object object = SerialModemDriver.this.SYNC_Reader;
                    synchronized (object) {
                        SerialModemDriver.this.dataReceived = true;
                        SerialModemDriver.this.SYNC_Reader.notifyAll();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    this.gtw.logError("ThreadReader error. ", e);
                    continue;
                }
                break;
            }
            this.gtw.logDebug("ThreadReader stopped.");
        }
    }
}

