/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.smslib.GatewayException;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.ModemGateway;

class IPModemDriver
extends AModemDriver {
    private String ipAddress;
    private int ipPort;
    TelnetClient tc;
    private InputStream in;
    private OutputStream out;
    private Peeker peeker;
    TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, false);
    EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
    SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);

    IPModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.ipAddress = tokens.nextToken();
        this.ipPort = Integer.parseInt(tokens.nextToken());
        this.tc = null;
    }

    void connectPort() throws GatewayException, IOException, InterruptedException {
        try {
            this.gateway.logInfo("Opening: " + this.ipAddress + " @" + this.ipPort);
            this.tc = new TelnetClient();
            this.tc.addOptionHandler((TelnetOptionHandler)this.ttopt);
            this.tc.addOptionHandler((TelnetOptionHandler)this.echoopt);
            this.tc.addOptionHandler((TelnetOptionHandler)this.gaopt);
            this.tc.connect(this.ipAddress, this.ipPort);
            this.in = this.tc.getInputStream();
            this.out = this.tc.getOutputStream();
            this.peeker = new Peeker();
        }
        catch (InvalidTelnetOptionException e) {
            throw new GatewayException("Unsupported telnet option for the selected IP connection.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectPort() throws IOException, InterruptedException {
        this.gateway.logInfo("Closing: " + this.ipAddress + " @" + this.ipPort);
        Object object = this.SYNC_Reader;
        synchronized (object) {
            if (this.tc != null) {
                this.tc.disconnect();
            }
            this.tc = null;
            this.peeker.interrupt();
            this.peeker.join();
        }
    }

    void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    boolean portHasData() throws IOException {
        return this.in.available() > 0;
    }

    public void write(char c) throws IOException {
        this.out.write((short)c);
        this.out.flush();
    }

    public void write(byte[] s) throws IOException {
        this.out.write(s);
        this.out.flush();
    }

    int read() throws IOException {
        return this.in.read();
    }

    private class Peeker
    extends Thread {
        public Peeker() {
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IPModemDriver.this.gateway.logDebug("Peeker started.");
            while (true) {
                try {
                    while (true) {
                        if (IPModemDriver.this.tc != null && IPModemDriver.this.portHasData()) {
                            Object object = IPModemDriver.this.SYNC_Reader;
                            synchronized (object) {
                                IPModemDriver.this.dataReceived = true;
                                IPModemDriver.this.SYNC_Reader.notifyAll();
                            }
                        }
                        Peeker.sleep(IPModemDriver.this.gateway.getService().S.SERIAL_POLLING_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                    if (IPModemDriver.this.tc != null) continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IPModemDriver.this.gateway.logDebug("Peeker stopped.");
        }
    }
}

