/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.TimeoutException;
import org.smslib.modem.ModemGateway;

public abstract class AModemDriver {
    private static final String rxErrorWithCode = "\\s*[\\p{ASCII}]*\\s*\\+(CM[ES])\\s+ERROR: (\\d+)\\s";
    private static final String rxPlainError = "\\s*[\\p{ASCII}]*\\s*(ERROR|NO CARRIER|NO DIALTONE)\\s";
    protected Object SYNC_Reader = new Object();
    protected Object SYNC_Commander = new Object();
    protected ModemGateway gateway;
    protected boolean dataReceived;
    volatile boolean connected;
    CharQueue queue;
    private ModemReader modemReader;
    KeepAlive keepAlive;
    AsyncNotifier asyncNotifier;
    AsyncMessageProcessor asyncMessageProcessor;
    private int lastError;
    static int OK = 0;

    AModemDriver(ModemGateway myGateway, String deviceParms) {
        this.gateway = myGateway;
        this.connected = false;
        this.dataReceived = false;
        this.queue = new CharQueue();
    }

    abstract void connectPort() throws GatewayException, IOException, InterruptedException;

    abstract void disconnectPort() throws IOException, InterruptedException;

    abstract void clear() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.SYNC_Commander;
        synchronized (object) {
            try {
                this.connectPort();
                this.connected = true;
                this.keepAlive = new KeepAlive();
                this.modemReader = new ModemReader();
                this.asyncNotifier = new AsyncNotifier();
                this.asyncMessageProcessor = new AsyncMessageProcessor();
                this.clearBuffer();
                this.getGateway().getATHandler().reset();
                this.getGateway().getATHandler().sync();
                this.getGateway().getATHandler().echoOff();
                while (true) {
                    String response = this.getGateway().getATHandler().getSimStatus();
                    while (response.indexOf("BUSY") >= 0) {
                        this.getGateway().logDebug("SIM found busy, waiting...");
                        Thread.sleep(this.getGateway().getService().S.AT_WAIT_SIMPIN);
                        response = this.getGateway().getATHandler().getSimStatus();
                    }
                    if (response.indexOf("SIM PIN2") >= 0) {
                        this.getGateway().logDebug("SIM requesting PIN2.");
                        if (this.getGateway().getSimPin2() == null || this.getGateway().getSimPin2().length() == 0) {
                            throw new GatewayException("The GSM modem requires SIM PIN2 to operate.");
                        }
                        if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin2())) {
                            throw new GatewayException("SIM PIN2 provided is not accepted by the GSM modem.");
                        }
                        Thread.sleep(this.getGateway().getService().S.AT_WAIT_SIMPIN);
                        continue;
                    }
                    if (response.indexOf("SIM PIN") >= 0) {
                        this.getGateway().logDebug("SIM requesting PIN.");
                        if (this.getGateway().getSimPin() == null || this.getGateway().getSimPin().length() == 0) {
                            throw new GatewayException("The GSM modem requires SIM PIN to operate.");
                        }
                        if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin())) {
                            throw new GatewayException("SIM PIN provided is not accepted by the GSM modem.");
                        }
                        Thread.sleep(this.getGateway().getService().S.AT_WAIT_SIMPIN);
                        continue;
                    }
                    if (response.indexOf("READY") >= 0 || response.indexOf("OK") >= 0) break;
                    this.getGateway().logWarn("Cannot understand SIMPIN response: " + response + ", will wait for a while...");
                    Thread.sleep(this.getGateway().getService().S.AT_WAIT_SIMPIN);
                }
                this.getGateway().getATHandler().echoOff();
                this.getGateway().getATHandler().init();
                this.getGateway().getATHandler().echoOff();
                this.waitForNetworkRegistration();
                this.getGateway().getATHandler().setVerboseErrors();
                if (this.getGateway().getATHandler().getStorageLocations().length() == 0) {
                    try {
                        this.getGateway().getATHandler().readStorageLocations();
                        this.getGateway().logInfo("MEM: Storage Locations Found: " + this.getGateway().getATHandler().getStorageLocations());
                    }
                    catch (Exception e) {
                        this.getGateway().getATHandler().setStorageLocations("--");
                        this.getGateway().logWarn("Storage locations could *not* be retrieved, will proceed with defaults.", e);
                    }
                }
                if (!this.getGateway().getATHandler().setIndications()) {
                    this.getGateway().logWarn("Callback indications were *not* set succesfully!");
                }
                if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
                    if (!this.getGateway().getATHandler().setPduProtocol()) {
                        throw new GatewayException("The GSM modem does not support the PDU protocol.");
                    }
                } else if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT && !this.getGateway().getATHandler().setTextProtocol()) {
                    throw new GatewayException("The GSM modem does not support the TEXT protocol.");
                }
            }
            catch (TimeoutException t) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() throws IOException, InterruptedException {
        Object object = this.SYNC_Commander;
        synchronized (object) {
            this.connected = false;
            if (this.keepAlive != null) {
                this.getGateway().logDebug("Trying to shutdown keepAlive thread...");
                this.keepAlive.interrupt();
                this.keepAlive.join();
                this.keepAlive = null;
            }
            if (this.asyncNotifier != null) {
                this.getGateway().logDebug("Trying to shutdown asyncNotifier thread...");
                this.asyncNotifier.interrupt();
                this.asyncNotifier.join();
                this.asyncNotifier = null;
            }
            if (this.asyncMessageProcessor != null) {
                this.getGateway().logDebug("Trying to shutdown asyncMessageProcessor thread...");
                this.asyncMessageProcessor.interrupt();
                this.asyncMessageProcessor.join();
                this.asyncMessageProcessor = null;
            }
            if (this.modemReader != null) {
                this.getGateway().logDebug("Trying to shutdown modemReader thread...");
                this.modemReader.interrupt();
                this.modemReader.join();
                this.modemReader = null;
            }
            this.disconnectPort();
        }
    }

    public abstract void write(char var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    abstract int read() throws IOException;

    abstract boolean portHasData() throws IOException;

    public boolean dataAvailable() throws InterruptedException {
        return this.queue.peek() != -1;
    }

    public void write(String s) throws IOException {
        this.getGateway().logDebug("SEND :" + this.formatLog(new StringBuffer(s)));
        this.write(s.getBytes());
    }

    public void AddToQueue(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.queue.put((byte)s.charAt(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getResponse() throws GatewayException, TimeoutException, IOException {
        this.setLastError(-1);
        String[] terminators = this.getGateway().getATHandler().getTerminators();
        StringBuffer buffer = new StringBuffer(this.getGateway().getService().S.SERIAL_BUFFER_SIZE);
        try {
            int i;
            String response;
            while (true) {
                if (this.queue.peek() == 10 || this.queue.peek() == 13) {
                    this.queue.get();
                    continue;
                }
                while (true) {
                    byte c = this.queue.get();
                    if (this.getGateway().getService().S.DEBUG_QUEUE) {
                        this.getGateway().logDebug("OUT READER QUEUE : " + c + " / " + (char)c);
                    }
                    if (c == 10) break;
                    buffer.append((char)c);
                }
                if (buffer.charAt(buffer.length() - 1) != '\r') {
                    buffer.append('\r');
                }
                response = buffer.toString();
                boolean terminate = false;
                for (i = 0; i < terminators.length; ++i) {
                    if (!response.matches(terminators[i])) continue;
                    terminate = true;
                    break;
                }
                if (terminate) break;
            }
            this.getGateway().logDebug("BUFFER: " + buffer);
            if (i >= terminators.length - 4) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(buffer.toString());
                if (event != AGateway.AsyncEvents.INBOUNDMESSAGE && event != AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE && event != AGateway.AsyncEvents.INBOUNDCALL) return this.getResponse();
                this.asyncNotifier.setEvent(event, buffer.toString());
                return this.getResponse();
            }
            if (response.matches(rxErrorWithCode)) {
                Pattern p = Pattern.compile(rxErrorWithCode);
                Matcher m = p.matcher(response);
                if (!m.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m.group(1).equals("CME")) {
                        int code = Integer.parseInt(m.group(2));
                        this.setLastError(5000 + code);
                    }
                    if (!m.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m.group(1));
                    int code = Integer.parseInt(m.group(2));
                    this.setLastError(6000 + code);
                }
                catch (NumberFormatException e) {
                    this.getGateway().logDebug("Error on number conversion while interpreting response: ");
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.setLastError(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.setLastError(0);
            } else {
                this.setLastError(10000);
            }
            this.getGateway().logDebug("RECV :" + this.formatLog(buffer));
            return buffer.toString();
        }
        catch (InterruptedException e) {
            this.getGateway().logWarn("GetResponse() Interrupted.", e);
            return buffer.toString();
        }
        catch (TimeoutException e) {
            this.getGateway().logDebug("Buffer contents on timeout: " + buffer);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException, InterruptedException {
        Object object = this.SYNC_Commander;
        synchronized (object) {
            this.getGateway().logDebug("clearBuffer() called.");
            Thread.sleep(this.getGateway().getService().S.SERIAL_CLEAR_WAIT);
            this.clear();
            this.queue.clear();
        }
    }

    boolean waitForNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        String response;
        while ((response = this.getGateway().getATHandler().getNetworkRegistration()).indexOf("ERROR") <= 0) {
            int answer;
            response = response.replaceAll("\\s+OK\\s+", "");
            response = response.replaceAll("\\s+", "");
            response = response.replaceAll("\\+CREG:", "");
            StringTokenizer tokens = new StringTokenizer(response, ",");
            tokens.nextToken();
            try {
                answer = Integer.parseInt(tokens.nextToken());
            }
            catch (Exception e) {
                answer = -1;
            }
            switch (answer) {
                case 0: {
                    this.getGateway().logError("GSM: Auto-registration disabled!");
                    throw new GatewayException("GSM Network Auto-Registration disabled!");
                }
                case 1: {
                    this.getGateway().logInfo("GSM: Registered to home network.");
                    return true;
                }
                case 2: {
                    this.getGateway().logWarn("GSM: Not registered, searching for network...");
                    break;
                }
                case 3: {
                    this.getGateway().logError("GSM: Network registration denied!");
                    throw new GatewayException("GSM Network Registration denied!");
                }
                case 4: {
                    this.getGateway().logError("GSM: Unknown registration error!");
                    throw new GatewayException("GSM Network Registration error!");
                }
                case 5: {
                    this.getGateway().logInfo("GSM: Registered to foreign network (roaming).");
                    return true;
                }
                case -1: {
                    this.getGateway().logInfo("GSM: Invalid CREG response.");
                    throw new GatewayException("GSM: Invalid CREG response.");
                }
            }
            Thread.sleep(this.getGateway().getService().S.AT_WAIT_NETWORK);
        }
        return false;
    }

    private String formatLog(StringBuffer s) {
        StringBuffer response = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    response.append("(cr)");
                    continue block5;
                }
                case '\n': {
                    response.append("(lf)");
                    continue block5;
                }
                case '\t': {
                    response.append("(tab)");
                    continue block5;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        response.append(c);
                        continue block5;
                    }
                    response.append("(" + c + ")");
                }
            }
        }
        return response.toString();
    }

    void setLastError(int myLastError) {
        this.lastError = myLastError;
    }

    public int getLastError() {
        return this.lastError;
    }

    public String getLastErrorText() {
        if (this.getLastError() == 0) {
            return "OK";
        }
        if (this.getLastError() == -1) {
            return "Invalid or empty response";
        }
        if (this.getLastError() / 1000 == 5) {
            return "CME Error " + this.getLastError() % 1000;
        }
        if (this.getLastError() / 1000 == 6) {
            return "CMS Error " + this.getLastError() % 1000;
        }
        return "Error: unknown";
    }

    public boolean isOk() {
        return this.getLastError() == OK;
    }

    ModemGateway getGateway() {
        return this.gateway;
    }

    private class AsyncMessageProcessor
    extends Thread {
        private List<InboundMessage> msgList = new ArrayList<InboundMessage>();
        private Object SYNC = new Object();
        private boolean process = false;

        public AsyncMessageProcessor() {
            this.setPriority(10);
            this.start();
            AModemDriver.this.getGateway().logDebug("AsyncMessageProcessor thread started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProcess() {
            Object object = this.SYNC;
            synchronized (object) {
                if (this.process) {
                    return;
                }
                this.process = true;
                this.SYNC.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: while (true) {
                try {
                    while (true) {
                        Object object = this.SYNC;
                        synchronized (object) {
                            if (!this.process) {
                                this.SYNC.wait();
                                if (!AModemDriver.this.connected) {
                                    break block12;
                                }
                            }
                        }
                        if (AModemDriver.this.gateway.getInboundNotification() != null) {
                            AModemDriver.this.getGateway().readMessages(this.msgList, InboundMessage.MessageClasses.ALL);
                            for (InboundMessage msg : this.msgList) {
                                switch (msg.getType()) {
                                    case INBOUND: {
                                        AModemDriver.this.getGateway().getInboundNotification().process(AModemDriver.this.getGateway().getGatewayId(), Message.MessageTypes.INBOUND, msg);
                                        break;
                                    }
                                    case STATUSREPORT: {
                                        AModemDriver.this.getGateway().getInboundNotification().process(AModemDriver.this.getGateway().getGatewayId(), Message.MessageTypes.STATUSREPORT, msg);
                                        break;
                                    }
                                }
                            }
                        }
                        this.msgList.clear();
                        this.process = false;
                    }
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.connected) continue;
                }
                catch (GatewayException e) {
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                break;
            }
            AModemDriver.this.getGateway().logDebug("AsyncMessageProcessor thread ended.");
        }
    }

    private class AsyncNotifier
    extends Thread {
        private BlockingQueue<Event> eventQueue;
        private Object SYNC = new Object();

        public AsyncNotifier() {
            this.eventQueue = new LinkedBlockingQueue<Event>();
            this.setPriority(1);
            this.start();
            AModemDriver.this.getGateway().logDebug("AsyncNotifier thread started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setEvent(AGateway.AsyncEvents event, String response) {
            Object object = this.SYNC;
            synchronized (object) {
                Event ev = new Event(event, response);
                AModemDriver.this.getGateway().logDebug("Storing AsyncEvent: " + ev);
                this.eventQueue.add(ev);
                this.SYNC.notify();
            }
        }

        protected String getMemLoc(String indication) {
            Pattern p = Pattern.compile("\\+?\"\\S+\"");
            Matcher m = p.matcher(indication);
            if (m.find()) {
                return indication.substring(m.start(), m.end()).replaceAll("\"", "");
            }
            return "";
        }

        protected int getMemIndex(String indication) {
            Pattern p = Pattern.compile("\\+?\\d+");
            Matcher m = p.matcher(indication);
            if (m.find()) {
                return Integer.parseInt(indication.substring(m.start(), m.end()).replaceAll("\"", ""));
            }
            return -1;
        }

        protected String getOriginator(String indication) {
            Pattern p = Pattern.compile("\\+?\"\\S+\"");
            Matcher m = p.matcher(indication);
            if (m.find()) {
                return indication.substring(m.start(), m.end()).replaceAll("\"", "");
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String response;
                        Event event = this.eventQueue.take();
                        AModemDriver.this.getGateway().logDebug("Processing AsyncEvent: " + event);
                        if (event.event == AGateway.AsyncEvents.INBOUNDMESSAGE) {
                            AModemDriver.this.getGateway().logDebug("Inbound message detected!");
                            event.event = AGateway.AsyncEvents.NOTHING;
                            response = event.response;
                            AModemDriver.this.asyncMessageProcessor.setProcess();
                            continue;
                        }
                        if (event.event == AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE) {
                            AModemDriver.this.getGateway().logDebug("Inbound status report message detected!");
                            event.event = AGateway.AsyncEvents.NOTHING;
                            response = event.response;
                            AModemDriver.this.asyncMessageProcessor.setProcess();
                            continue;
                        }
                        if (event.event != AGateway.AsyncEvents.INBOUNDCALL) continue;
                        AModemDriver.this.getGateway().logDebug("Inbound call detected!");
                        event.event = AGateway.AsyncEvents.NOTHING;
                        Object object = AModemDriver.this.SYNC_Commander;
                        synchronized (object) {
                            AModemDriver.this.getGateway().getATHandler().switchToCmdMode();
                            AModemDriver.this.getGateway().getModemDriver().write("ATH\r");
                            AModemDriver.this.getGateway().getModemDriver().getResponse();
                            response = event.response;
                        }
                        if (AModemDriver.this.getGateway().getCallNotification() == null) continue;
                        AModemDriver.this.getGateway().getCallNotification().process(AModemDriver.this.getGateway().getGatewayId(), this.getOriginator(response));
                    }
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.connected) continue;
                }
                catch (GatewayException e) {
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                break;
            }
            AModemDriver.this.gateway.logDebug("AsyncNotifier thread ended.");
        }

        class Event {
            AGateway.AsyncEvents event;
            String response;

            public Event(AGateway.AsyncEvents myEvent, String myResponse) {
                this.event = myEvent;
                this.response = myResponse;
            }

            public String toString() {
                return "Event: " + (Object)((Object)this.event) + " / Response: " + this.response;
            }
        }
    }

    private class KeepAlive
    extends Thread {
        public KeepAlive() {
            this.setPriority(1);
            this.start();
            AModemDriver.this.getGateway().logDebug("ModemDriver: KeepAlive thread started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: while (true) {
                try {
                    do {
                        try {
                            KeepAlive.sleep(AModemDriver.this.getGateway().getService().S.SERIAL_KEEPALIVE_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!AModemDriver.this.connected) break block9;
                    } while (AModemDriver.this.getGateway().getGatewayStatus() != AGateway.GatewayStatuses.OK);
                    Object e = AModemDriver.this.SYNC_Commander;
                    synchronized (e) {
                        if (!AModemDriver.this.connected) {
                            break;
                        }
                        AModemDriver.this.getGateway().logDebug("** KeepAlive START **");
                        try {
                            if (!AModemDriver.this.getGateway().getATHandler().isAlive()) {
                                AModemDriver.this.getGateway().setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                            }
                        }
                        catch (Exception e2) {
                            AModemDriver.this.getGateway().setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                        }
                        AModemDriver.this.getGateway().logDebug("** KeepAlive END **");
                        continue;
                    }
                }
                catch (Exception e) {
                    AModemDriver.this.getGateway().logError("ModemDriver: KeepAlive Error.", e);
                    AModemDriver.this.getGateway().setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                    continue;
                }
                break;
            }
            AModemDriver.this.getGateway().logDebug("ModemDriver: KeepAlive thread ended.");
        }
    }

    private class ModemReader
    extends Thread {
        public ModemReader() {
            this.start();
            AModemDriver.this.getGateway().logDebug("ModemReader thread started.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AModemDriver.this.connected) {
                try {
                    Object object = AModemDriver.this.SYNC_Reader;
                    synchronized (object) {
                        if (!AModemDriver.this.dataReceived) {
                            AModemDriver.this.SYNC_Reader.wait();
                        }
                        if (!AModemDriver.this.connected) {
                            break;
                        }
                        int c = AModemDriver.this.read();
                        while (c != -1) {
                            AModemDriver.this.queue.put((byte)c);
                            if (!AModemDriver.this.portHasData()) break;
                            c = AModemDriver.this.read();
                        }
                        AModemDriver.this.dataReceived = false;
                    }
                    String data = AModemDriver.this.queue.peek(6);
                    if (data.indexOf("CMTI") < 0 && data.indexOf("CDSI") < 0 && data.indexOf("RING") < 0) continue;
                    AModemDriver.this.keepAlive.interrupt();
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.connected) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AModemDriver.this.getGateway().logDebug("ModemReader thread ended.");
        }
    }

    private class CharQueue {
        byte[] buffer = null;
        int bufferStart = 0;
        int bufferEnd = 0;

        public synchronized void put(byte c) {
            if (this.buffer == null) {
                this.buffer = new byte[AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE];
            }
            this.buffer[this.bufferEnd] = c;
            ++this.bufferEnd;
            if (this.bufferEnd == AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE) {
                this.bufferEnd = 0;
            }
            if (AModemDriver.this.getGateway().getService().S.DEBUG_QUEUE) {
                AModemDriver.this.getGateway().logDebug("IN READER QUEUE : " + c + " / " + (char)c);
            }
            this.notifyAll();
        }

        public synchronized void put(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.put((byte)s.charAt(i));
            }
        }

        public synchronized byte get() throws TimeoutException, InterruptedException {
            if (this.buffer == null) {
                this.buffer = new byte[AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.bufferStart == this.bufferEnd) {
                        this.wait(AModemDriver.this.getGateway().getService().S.SERIAL_TIMEOUT);
                    }
                    if (this.bufferStart == this.bufferEnd) {
                        throw new TimeoutException("No response from device.");
                    }
                    byte c = this.buffer[this.bufferStart];
                    ++this.bufferStart;
                    if (this.bufferStart == AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE) {
                        this.bufferStart = 0;
                    }
                    return c;
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.getGateway().isStarted()) {
                        AModemDriver.this.getGateway().logWarn("Ignoring InterruptedException in Queue.get().");
                        continue;
                    }
                    AModemDriver.this.getGateway().logWarn("Re-throwing InterruptedException in Queue.get() - should be during shutdown...");
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized byte peek() throws InterruptedException {
            if (this.buffer == null) {
                this.buffer = new byte[AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.bufferStart == this.bufferEnd) {
                        this.wait(AModemDriver.this.getGateway().getService().S.SERIAL_TIMEOUT);
                    }
                    if (this.bufferStart == this.bufferEnd) {
                        return -1;
                    }
                    return this.buffer[this.bufferStart];
                }
                catch (InterruptedException e) {
                    if (AModemDriver.this.getGateway().isStarted()) {
                        AModemDriver.this.getGateway().logWarn("Ignoring InterruptedException in Queue.peek().", e);
                        continue;
                    }
                    AModemDriver.this.getGateway().logWarn("Re-throwing InterruptedException in Queue.peek() - should be during shutdown...", e);
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized String peek(int sizeToRead) {
            if (this.buffer == null) {
                this.buffer = new byte[AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE];
            }
            int size = sizeToRead;
            if (this.bufferStart == this.bufferEnd) {
                return "";
            }
            StringBuffer result = new StringBuffer(size);
            int i = this.bufferStart;
            while (size > 0) {
                if (this.buffer[i] != 10 && this.buffer[i] != 13) {
                    result.append((char)this.buffer[i]);
                    --size;
                }
                if (++i == AModemDriver.this.getGateway().getService().S.SERIAL_BUFFER_SIZE) {
                    i = 0;
                }
                if (i != this.bufferEnd) continue;
                break;
            }
            return result.toString();
        }

        public synchronized void clear() {
            this.bufferStart = 0;
            this.bufferEnd = 0;
        }

        public void dump() {
            for (int i = this.bufferStart; i < this.bufferEnd; ++i) {
                System.out.println(this.buffer[i] + " -> " + (char)this.buffer[i]);
            }
        }
    }
}

