/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.smslib.helper.SerialPort;

public class SerialPortEvent {
    private static Class<?> classSerialPortEvent;
    public static final int BI;
    public static final int CD;
    public static final int CTS;
    public static final int DATA_AVAILABLE;
    public static final int DSR;
    public static final int FE;
    public static final int OE;
    public static final int OUTPUT_BUFFER_EMPTY;
    public static final int PE;
    public static final int RI;
    private Object realObject;

    public SerialPortEvent(SerialPort srcport, int eventtype, boolean oldvalue, boolean newvalue) {
        if (classSerialPortEvent == null) {
            throw new RuntimeException("SerialPortEvent class not found");
        }
        try {
            Constructor<?> constr = classSerialPortEvent.getConstructor(SerialPort.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            this.realObject = constr.newInstance(srcport, eventtype, oldvalue, newvalue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    SerialPortEvent(Object obj) {
        if (classSerialPortEvent == null) {
            throw new RuntimeException("SerialPortEvent class not found");
        }
        this.realObject = obj;
    }

    public int getEventType() {
        int eventType;
        try {
            Method method = classSerialPortEvent.getMethod("getEventType", null);
            eventType = (Integer)method.invoke(this.realObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return eventType;
    }

    public boolean getNewValue() {
        boolean newValue;
        try {
            Method method = classSerialPortEvent.getMethod("getNewValue", null);
            newValue = (Boolean)method.invoke(this.realObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newValue;
    }

    public boolean getOldValue() {
        boolean oldValue;
        try {
            Method method = classSerialPortEvent.getMethod("getOldValue", null);
            oldValue = (Boolean)method.invoke(this.realObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return oldValue;
    }

    static {
        try {
            classSerialPortEvent = Class.forName("javax.comm.SerialPortEvent");
        }
        catch (ClassNotFoundException e1) {
            try {
                classSerialPortEvent = Class.forName("gnu.io.SerialPortEvent");
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("SerialPortEvent class not found");
            }
        }
        try {
            Field f = classSerialPortEvent.getField("BI");
            BI = f.getInt(null);
            f = classSerialPortEvent.getField("CD");
            CD = f.getInt(null);
            f = classSerialPortEvent.getField("CTS");
            CTS = f.getInt(null);
            f = classSerialPortEvent.getField("DATA_AVAILABLE");
            DATA_AVAILABLE = f.getInt(null);
            f = classSerialPortEvent.getField("DSR");
            DSR = f.getInt(null);
            f = classSerialPortEvent.getField("FE");
            FE = f.getInt(null);
            f = classSerialPortEvent.getField("OE");
            OE = f.getInt(null);
            f = classSerialPortEvent.getField("OUTPUT_BUFFER_EMPTY");
            OUTPUT_BUFFER_EMPTY = f.getInt(null);
            f = classSerialPortEvent.getField("PE");
            PE = f.getInt(null);
            f = classSerialPortEvent.getField("RI");
            RI = f.getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

