/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Library;
import org.smslib.LoadBalancer;
import org.smslib.OutboundMessage;
import org.smslib.RoundRobinLoadBalancer;
import org.smslib.Router;
import org.smslib.SMSLibException;
import org.smslib.Settings;
import org.smslib.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final String LOG4J_CONF_1 = "smslib-log4j.properties";
    private static final String LOG4J_CONF_2 = "log4j.properties";
    private static final String LOG4J_CONF_XML = "smslib-log4j.xml";
    private Logger logger;
    List<AGateway> gtwList;
    private Router router;
    private LoadBalancer loadBalancer;
    private WatchDog watchDog;
    public Settings S = new Settings();

    public Service() {
        try {
            this.logger = Logger.getLogger((String)"org.smslib");
            this.logger.setLevel(this.S.DEBUG ? Level.ALL : Level.WARN);
            this.loadLoggerProps();
            this.logInfo(Library.getLibraryDescription());
            this.logInfo("Version: " + Library.getLibraryVersion());
            this.logInfo("JRE Version: " + System.getProperty("java.version"));
            this.logInfo("JRE Impl Version: " + System.getProperty("java.vm.version"));
            this.logInfo("O/S: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
            this.gtwList = new ArrayList<AGateway>();
            this.setRouter(new Router(this));
            this.setLoadBalancer(new RoundRobinLoadBalancer(this));
        }
        catch (Exception e) {
            this.logger.fatal((Object)e);
        }
    }

    public Service(Logger myLogger) {
        this.logger = myLogger;
        myLogger.setLevel(this.S.DEBUG ? Level.ALL : Level.WARN);
        this.logInfo(Library.getLibraryDescription());
        this.logInfo("Version: " + Library.getLibraryVersion());
        this.logInfo("JRE Version: " + System.getProperty("java.version"));
        this.logInfo("JRE Impl Version: " + System.getProperty("java.vm.version"));
        this.logInfo("O/S: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
        this.gtwList = new ArrayList<AGateway>();
        this.setRouter(new Router(this));
        this.setLoadBalancer(new RoundRobinLoadBalancer(this));
    }

    private void loadLoggerProps() {
        if (new File(LOG4J_CONF_1).exists()) {
            PropertyConfigurator.configure((String)LOG4J_CONF_1);
        } else if (new File(LOG4J_CONF_2).exists()) {
            PropertyConfigurator.configure((String)LOG4J_CONF_2);
        } else if (new File(LOG4J_CONF_XML).exists()) {
            DOMConfigurator.configure((String)LOG4J_CONF_XML);
        } else {
            BasicConfigurator.configure();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGateway(AGateway gtw) {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            gtw.setService(this);
            this.gtwList.add(gtw);
        }
    }

    public synchronized void startService() throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.startService(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startService(boolean startAll) throws SMSLibException, TimeoutException, GatewayException, IOException, InterruptedException {
        LinkedList<Exception> eList = new LinkedList<Exception>();
        LinkedList<AGateway> gList = new LinkedList<AGateway>();
        this.watchDog = new WatchDog();
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            if (this.gtwList.size() == 0) {
                throw new SMSLibException("No gateways are defined.");
            }
            for (AGateway gtw : this.gtwList) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Starter
                extends Thread {
                    AGateway gtw;
                    List<Exception> eList;
                    List<AGateway> gList;

                    public Starter(AGateway myGtw, List<Exception> myEList, List<AGateway> myGList) {
                        this.gtw = myGtw;
                        this.eList = myEList;
                        this.gList = myGList;
                    }

                    @Override
                    public void run() {
                        try {
                            this.gtw.startGateway();
                            this.gList.add(this.gtw);
                        }
                        catch (Exception e) {
                            this.eList.add(e);
                        }
                    }
                }
                new Starter(gtw, eList, gList).start();
            }
            while (gList.size() != this.gtwList.size() && eList.size() == 0) {
                Thread.sleep(1000L);
            }
            if (startAll) {
                if (eList.size() != 0) {
                    Exception e = (Exception)eList.get(0);
                    if (e instanceof TimeoutException) {
                        throw (TimeoutException)e;
                    }
                    if (e instanceof GatewayException) {
                        throw (GatewayException)e;
                    }
                    if (e instanceof SMSLibException) {
                        throw (SMSLibException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof InterruptedException) {
                        throw (InterruptedException)e;
                    }
                } else {
                    eList.clear();
                    gList.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopService() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.watchDog != null) {
            this.watchDog.interrupt();
            this.watchDog.join();
        }
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            for (AGateway gtw : this.gtwList) {
                gtw.stopGateway();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            for (AGateway gtw : this.gtwList) {
                if (!gtw.isInbound()) continue;
                try {
                    this.readMessages(msgList, msgClass, gtw);
                }
                catch (TimeoutException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (IOException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
        }
        return msgList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, String gtwId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            AGateway gtw = this.findGateway(gtwId);
            if (gtw != null && gtw.isInbound()) {
                try {
                    this.readMessages(msgList, msgClass, gtw);
                }
                catch (TimeoutException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (IOException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
        }
        return msgList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, AGateway gtw) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            try {
                gtw.readMessages(msgList, msgClass);
            }
            catch (TimeoutException e) {
                this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
            }
            catch (IOException e) {
                this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
            }
        }
        return msgList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundMessage readMessage(String gtwId, String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        InboundMessage msg = null;
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            AGateway gtw = this.findGateway(gtwId);
            if (gtw != null && gtw.isInbound()) {
                try {
                    msg = gtw.readMessage(memLoc, memIndex);
                }
                catch (TimeoutException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
                catch (IOException e) {
                    this.logWarn("readMessages(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                }
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            AGateway gtw = this.routeMessage(msg);
            if (gtw != null) {
                try {
                    return gtw.sendMessage(msg);
                }
                catch (TimeoutException e) {
                    this.logWarn("sendMessage(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                    msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                    return false;
                }
                catch (IOException e) {
                    this.logWarn("sendMessage(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                    msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                    return false;
                }
            }
            return false;
        }
    }

    public boolean sendMessage(OutboundMessage msg, String gtwId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        msg.setGatewayId(gtwId);
        return this.sendMessage(msg);
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.sendMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int sendMessages(Collection<OutboundMessage> msgList, String gtwId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gtwId);
            if (!this.sendMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueMessage(OutboundMessage msg) {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            AGateway gtw = this.routeMessage(msg);
            if (gtw != null) {
                return gtw.queueMessage(msg);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueMessage(OutboundMessage msg, String gtwId) {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            msg.setGatewayId(gtwId);
            return this.queueMessage(msg);
        }
    }

    public int queueMessages(Collection<OutboundMessage> msgList) {
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.queueMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    public int queueMessages(Collection<OutboundMessage> msgList, String gtwId) {
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gtwId);
            if (!this.queueMessage(msg)) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            AGateway gtw = this.findGateway(msg.getGatewayId());
            if (gtw != null) {
                try {
                    return gtw.deleteMessage(msg);
                }
                catch (TimeoutException e) {
                    this.logWarn("deleteMessage(): Gateway " + gtw.getGatewayId() + " does not respond, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                    return false;
                }
                catch (IOException e) {
                    this.logWarn("deleteMessage(): Gateway " + gtw.getGatewayId() + " throws IO errors, marking for restart.");
                    gtw.setGatewayStatus(AGateway.GatewayStatuses.RESTART);
                    return false;
                }
            }
            return false;
        }
    }

    public int getInboundMessageCount(String gtwId) {
        return this.getInboundMessageCount(this.findGateway(gtwId));
    }

    public int getInboundMessageCount(AGateway gtw) {
        return gtw != null ? gtw.getInboundMessageCount() : -1;
    }

    public int getOutboundMessageCount(String gtwId) {
        return this.getOutboundMessageCount(this.findGateway(gtwId));
    }

    public int getOutboundMessageCount(AGateway gtw) {
        return gtw != null ? gtw.getOutboundMessageCount() : -1;
    }

    public int getInboundMessageCount() {
        int total = 0;
        for (AGateway gtw : this.gtwList) {
            total += gtw.getInboundMessageCount();
        }
        return total;
    }

    public int getOutboundMessageCount() {
        int total = 0;
        for (AGateway gtw : this.gtwList) {
            total += gtw.getOutboundMessageCount();
        }
        return total;
    }

    public AGateway findGateway(String gtwId) {
        for (AGateway gtw : this.gtwList) {
            if (!gtw.getGatewayId().equals(gtwId)) continue;
            return gtw;
        }
        return null;
    }

    public Collection<AGateway> getGatewayList() {
        return this.gtwList;
    }

    public int getGatewayQueueLoad() {
        int total = 0;
        for (AGateway gtw : this.gtwList) {
            total += gtw.getQueueLoad();
        }
        return total;
    }

    public int getGatewayQueueLoad(OutboundMessage.MessagePriorities priority) {
        int total = 0;
        for (AGateway gtw : this.gtwList) {
            total += gtw.getQueueLoad(priority);
        }
        return total;
    }

    public int getGatewayQueueLoad(String gtwId) {
        AGateway gtw = this.findGateway(gtwId);
        return gtw == null ? 0 : gtw.getQueueLoad();
    }

    public int getGatewayQueueLoad(String gtwId, OutboundMessage.MessagePriorities priority) {
        AGateway gtw = this.findGateway(gtwId);
        return gtw == null ? 0 : gtw.getQueueLoad(priority);
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer myLoadBalancer) {
        this.loadBalancer = myLoadBalancer;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router myRouter) {
        this.router = myRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AGateway routeMessage(OutboundMessage msg) {
        List<AGateway> list = this.gtwList;
        synchronized (list) {
            return this.router.route(msg);
        }
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Exception e) {
        this.logger.error((Object)(message + (e == null ? "" : " (" + e.getMessage() + ")")));
    }

    public void logDebug(String message) {
        this.logDebug(message, null);
    }

    public void logDebug(String message, Exception e) {
        this.logger.debug((Object)(message + (e == null ? "" : " (" + e.getMessage() + ")")));
    }

    public void logWarn(String message) {
        this.logWarn(message, null);
    }

    public void logWarn(String message, Exception e) {
        this.logger.warn((Object)(message + (e == null ? "" : " (" + e.getMessage() + ")")));
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Exception e) {
        this.logger.info((Object)(message + (e == null ? "" : " (" + e.getMessage() + ")")));
    }

    public static void main(String[] args) {
        System.out.println(Library.getLibraryDescription());
        System.out.println("\nSMSLib API Version: " + Library.getLibraryVersion());
    }

    private class WatchDog
    extends Thread {
        public WatchDog() {
            this.start();
        }

        public void run() {
            Service.this.logDebug("WatchDog started.");
            while (true) {
                try {
                    while (true) {
                        Service.this.logInfo("WatchDog running...");
                        for (AGateway gtw : Service.this.gtwList) {
                            if (gtw.getGatewayStatus() != AGateway.GatewayStatuses.RESTART) continue;
                            Service.this.logWarn("WatchDog: Gateway: " + gtw.getGatewayId() + " restarting.");
                            try {
                                gtw.stopGateway();
                            }
                            catch (Exception e) {
                                Service.this.logWarn("WatchDog: error while shutting down Gateway: " + gtw.getGatewayId(), e);
                            }
                            try {
                                gtw.startGateway();
                            }
                            catch (Exception e) {
                                Service.this.logError("WatchDog: error while starting Gateway: " + gtw.getGatewayId(), e);
                            }
                        }
                        Thread.sleep(Service.this.S.WATCHDOG_INTERVAL);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    Service.this.logError("WatchDog error. ", e);
                    continue;
                }
                break;
            }
            Service.this.logDebug("WatchDog stopped.");
        }
    }
}

