/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.util.ArrayList;
import org.smslib.AGateway;
import org.smslib.OutboundMessage;
import org.smslib.Service;

public class Router {
    protected ArrayList<AGateway> candidates = new ArrayList();
    protected ArrayList<AGateway> allowed = new ArrayList();
    protected Service srv;

    public Router(Service mySrv) {
        this.srv = mySrv;
    }

    protected void preroute(OutboundMessage msg) {
        for (AGateway gtw : this.srv.getGatewayList()) {
            if (!gtw.isOutbound()) continue;
            this.candidates.add(gtw);
        }
    }

    protected AGateway route(OutboundMessage msg) {
        AGateway gw;
        this.beginRouting();
        this.preroute(msg);
        this.customRouting(msg);
        if (this.allowed.size() > 0) {
            gw = this.srv.getLoadBalancer().balance(msg, this.allowed);
        } else {
            msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            gw = null;
        }
        this.finishRouting();
        return gw;
    }

    public void customRouting(OutboundMessage msg) {
        if (msg.getGatewayId().length() == 0 || msg.getGatewayId().equals("*")) {
            this.allowed.addAll(this.candidates);
        } else if (this.srv.findGateway(msg.getGatewayId()) != null) {
            this.allowed.add(this.srv.findGateway(msg.getGatewayId()));
        }
    }

    protected final void beginRouting() {
        this.candidates.clear();
        this.allowed.clear();
    }

    protected final void finishRouting() {
        this.candidates.clear();
        this.allowed.clear();
    }
}

