/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public abstract class Message
implements Serializable {
    private static final long serialVersionUID = 4461754947231415569L;
    private static long messageIdSeed = 0L;
    private final long messageId = messageIdSeed++;
    private String gtwId = "";
    private MessageTypes type;
    private Date date;
    private String id;
    private String text;
    private MessageEncodings encoding;
    protected int dstPort;
    protected int srcPort;
    protected int messageCharCount;

    public Message(MessageTypes myType, Date myDate, String myText) {
        this.type = myType;
        this.id = "";
        this.setDate(myDate);
        this.text = myText;
        this.encoding = MessageEncodings.ENC7BIT;
        this.srcPort = -1;
        this.dstPort = -1;
        this.messageCharCount = 0;
    }

    public Date getDate() {
        return this.date == null ? null : new Date(this.date.getTime());
    }

    public void setDate(Date myDate) {
        this.date = myDate != null ? new Date(myDate.getTime()) : null;
    }

    public MessageEncodings getEncoding() {
        return this.encoding;
    }

    public String getGatewayId() {
        return this.gtwId;
    }

    public void setGatewayId(String myGtwId) {
        this.gtwId = myGtwId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String myId) {
        this.id = myId;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getText() {
        return this.text;
    }

    protected void setText(String myText) {
        this.text = myText;
    }

    public void addText(String addText) throws UnsupportedEncodingException {
        this.text = this.text + addText;
    }

    public MessageTypes getType() {
        return this.type;
    }

    void setType(MessageTypes myType) {
        this.type = myType;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public void setDstPort(int myDstPort) {
        this.dstPort = myDstPort;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int mySrcPort) {
        this.srcPort = mySrcPort;
    }

    public void setEncoding(MessageEncodings myEncoding) {
        this.encoding = myEncoding;
    }

    public abstract String getPduUserData();

    public abstract String getPduUserDataHeader();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageTypes implements Serializable
    {
        INBOUND,
        OUTBOUND,
        STATUSREPORT,
        WAPSI,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageEncodings implements Serializable
    {
        ENC7BIT,
        ENC8BIT,
        ENCUCS2,
        ENCCUSTOM;

    }
}

