/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.smslib.GatewayException;
import org.smslib.ICallNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AGateway {
    protected boolean started;
    protected String gtwId;
    protected int attributes;
    protected boolean inbound;
    protected boolean outbound;
    protected Service srv;
    protected Protocols protocol;
    protected IInboundMessageNotification inboundNotification;
    protected IOutboundMessageNotification outboundNotification;
    protected ICallNotification callNotification;
    protected Statistics statistics;
    protected String from;
    protected int deliveryErrorCode;
    protected Thread queueManagerThread;
    protected PriorityBlockingQueue<OutboundMessage> messageQueue;
    protected GatewayStatuses gatewayStatus;

    public AGateway(String id) {
        this.gtwId = id;
        this.srv = null;
        this.started = false;
        this.inbound = false;
        this.outbound = false;
        this.attributes = 0;
        this.protocol = Protocols.PDU;
        this.inboundNotification = null;
        this.outboundNotification = null;
        this.callNotification = null;
        this.from = "";
        this.statistics = new Statistics();
        this.from = "";
        this.deliveryErrorCode = -1;
        this.gatewayStatus = GatewayStatuses.OK;
        this.messageQueue = new PriorityBlockingQueue<OutboundMessage>(50, new Comparator<OutboundMessage>(){

            @Override
            public int compare(OutboundMessage x, OutboundMessage y) {
                int comp = x.getPriority().compareTo(y.getPriority());
                if (comp == 0) {
                    comp = x.getDate().compareTo(y.getDate());
                }
                return comp;
            }
        });
    }

    public boolean isStarted() {
        return this.started;
    }

    int getAttributes() {
        return this.attributes;
    }

    public Service getService() {
        return this.srv;
    }

    public void setService(Service mySrv) {
        this.srv = mySrv;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setInbound(boolean value) {
        if ((this.attributes & 2) != 0) {
            this.inbound = value;
        }
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public void setOutbound(boolean value) {
        if ((this.attributes & 1) != 0) {
            this.outbound = value;
        }
    }

    public void setProtocol(Protocols myProtocoll) {
        this.protocol = myProtocoll;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public String getGatewayId() {
        return this.gtwId;
    }

    public GatewayStatuses getGatewayStatus() {
        return this.gatewayStatus;
    }

    public void setGatewayStatus(GatewayStatuses status) {
        this.gatewayStatus = status;
    }

    public IInboundMessageNotification getInboundNotification() {
        return this.inboundNotification;
    }

    public void setInboundNotification(IInboundMessageNotification myInboundNotification) {
        this.inboundNotification = myInboundNotification;
    }

    public IOutboundMessageNotification getOutboundNotification() {
        return this.outboundNotification;
    }

    public void setOutboundNotification(IOutboundMessageNotification myOutboundNotification) {
        this.outboundNotification = myOutboundNotification;
    }

    public ICallNotification getCallNotification() {
        return this.callNotification;
    }

    public void setCallNotification(ICallNotification myCallNotification) {
        this.callNotification = myCallNotification;
    }

    public int getInboundMessageCount() {
        return this.statistics.inbound;
    }

    public void incInboundMessageCount() {
        ++this.statistics.inbound;
    }

    public int getOutboundMessageCount() {
        return this.statistics.outbound;
    }

    public void incOutboundMessageCount() {
        ++this.statistics.outbound;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String myFrom) {
        this.from = myFrom;
    }

    public boolean queueMessage(OutboundMessage msg) {
        this.messageQueue.add(msg);
        return true;
    }

    public int queueMessages(Collection<OutboundMessage> msgList) {
        int count = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.queueMessage(msg)) continue;
            ++count;
        }
        return count;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.started = true;
        this.queueManagerThread = new Thread(new QueueManager());
        this.queueManagerThread.start();
        this.gatewayStatus = GatewayStatuses.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.started = false;
        if (this.queueManagerThread != null) {
            this.queueManagerThread.interrupt();
            try {
                this.queueManagerThread.join();
            }
            catch (InterruptedException e) {
                this.logInfo("Interrupted while waiting for gateway to stop.", e);
            }
            finally {
                this.queueManagerThread = null;
            }
        }
    }

    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int cnt = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.sendMessage(msg)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.queryMessage(msg.getRefNo());
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int getDeliveryErrorCode() {
        return this.deliveryErrorCode;
    }

    boolean isCapableOf(int att) {
        return (att & this.attributes) == att;
    }

    boolean conformsTo(int attrib, boolean required) {
        return !required || this.isCapableOf(attrib);
    }

    int getQueueLoad() {
        return this.getQueueLoad(OutboundMessage.MessagePriorities.LOW) + this.getQueueLoad(OutboundMessage.MessagePriorities.NORMAL) + this.getQueueLoad(OutboundMessage.MessagePriorities.HIGH);
    }

    int getQueueLoad(OutboundMessage.MessagePriorities priority) {
        int count = 0;
        for (OutboundMessage msg : this.messageQueue) {
            if (msg.getPriority() != priority) continue;
            ++count;
        }
        return count;
    }

    public void logError(String message) {
        this.srv.logError("GTW: " + this.gtwId + ": " + message, null);
    }

    public void logError(String message, Exception e) {
        this.srv.logError("GTW: " + this.gtwId + ": " + message, e);
    }

    public void logDebug(String message) {
        this.srv.logDebug("GTW: " + this.gtwId + ": " + message, null);
    }

    public void logDebug(String message, Exception e) {
        this.srv.logDebug("GTW: " + this.gtwId + ": " + message, e);
    }

    public void logWarn(String message) {
        this.srv.logWarn("GTW: " + this.gtwId + ": " + message, null);
    }

    public void logWarn(String message, Exception e) {
        this.srv.logWarn("GTW: " + this.gtwId + ": " + message, e);
    }

    public void logInfo(String message) {
        this.srv.logInfo("GTW: " + this.gtwId + ": " + message, null);
    }

    public void logInfo(String message, Exception e) {
        this.srv.logInfo("GTW: " + this.gtwId + ": " + message, e);
    }

    private class QueueManager
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block14: {
                OutboundMessage msg = null;
                AGateway.this.logInfo("Starting Queue Manager.", null);
                try {
                    if (!AGateway.this.started) break block14;
                    do {
                        block16: {
                            block15: {
                                msg = AGateway.this.messageQueue.take();
                                if (!AGateway.this.started || AGateway.this.gatewayStatus != GatewayStatuses.OK) break block14;
                                if (AGateway.this.sendMessage(msg)) break block15;
                                if (msg.getRetryCount() < AGateway.this.srv.S.QUEUE_RETRIES) {
                                    AGateway.this.logInfo("Reinserting message to queue.", null);
                                    msg.incrementRetryCount();
                                    AGateway.this.queueMessage(msg);
                                    break block16;
                                } else {
                                    AGateway.this.logWarn("Maximum number of queue retries exceeded, message lost.", null);
                                    msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                                    if (AGateway.this.getOutboundNotification() != null) {
                                        AGateway.this.getOutboundNotification().process(AGateway.this.gtwId, msg);
                                    }
                                }
                                break block16;
                            }
                            if (AGateway.this.getOutboundNotification() != null) {
                                AGateway.this.getOutboundNotification().process(AGateway.this.gtwId, msg);
                            }
                        }
                        msg = null;
                        try {
                            Thread.sleep(AGateway.this.srv.S.QUEUE_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (AGateway.this.started);
                }
                catch (InterruptedException e) {
                    if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                        AGateway.this.queueMessage(msg);
                    }
                    AGateway.this.logInfo("Interrupting queue.", e);
                }
                catch (Exception e) {
                    AGateway.this.logWarn("Queue exception, marking gateway for reset.", e);
                    AGateway.this.gatewayStatus = GatewayStatuses.RESTART;
                    try {
                        if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                            AGateway.this.queueMessage(msg);
                        }
                    }
                    catch (Exception e1) {
                        AGateway.this.logError("Fatal error during restart of the queue.", e1);
                    }
                }
            }
            AGateway.this.logInfo("QueueManager stopped.", null);
        }
    }

    static class Statistics {
        public int inbound = 0;
        public int outbound = 0;
    }

    public static class GatewayAttributes {
        public static final int SEND = 1;
        public static final int RECEIVE = 2;
        public static final int CUSTOMFROM = 4;
        public static final int BIGMESSAGES = 8;
        public static final int WAPSI = 16;
        public static final int PORTADDRESSING = 32;
        public static final int FLASHSMS = 64;
        public static final int DELIVERYREPORTS = 128;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsyncEvents {
        DELETE,
        NOTHING,
        INBOUNDMESSAGE,
        INBOUNDSTATUSREPORTMESSAGE,
        INBOUNDCALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GatewayStatuses {
        OK,
        FAILURE,
        RESTART;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocols {
        PDU,
        TEXT;

    }
}

