/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040.ie;

import org.ajwcc.pduUtils.gsm3040.ie.InformationElement;

public class ConcatInformationElement
extends InformationElement {
    private static final int CONCAT_IE_LENGTH_16BIT = 6;
    private static final int CONCAT_IE_LENGTH_8BIT = 5;
    public static final int CONCAT_8BIT_REF = 0;
    public static final int CONCAT_16BIT_REF = 8;
    private static int defaultConcatType = 0;
    private static int defaultConcatLength = 5;

    public static int getDefaultConcatLength() {
        return defaultConcatLength;
    }

    public static int getDefaultConcatType() {
        return defaultConcatType;
    }

    public static void setDefaultConcatType(int identifier) {
        switch (identifier) {
            case 0: {
                defaultConcatType = 0;
                defaultConcatLength = 5;
                break;
            }
            case 8: {
                defaultConcatType = 8;
                defaultConcatLength = 6;
                break;
            }
            default: {
                throw new RuntimeException("Invalid Concat type");
            }
        }
    }

    ConcatInformationElement(byte identifier, byte[] data) {
        super(identifier, data);
        if (this.getIdentifier() == 0) {
            if (data.length != 3) {
                throw new RuntimeException("Invalid data length in: " + this.getClass().getSimpleName());
            }
        } else if (this.getIdentifier() == 8) {
            if (data.length != 4) {
                throw new RuntimeException("Invalid data length in: " + this.getClass().getSimpleName());
            }
        } else {
            throw new RuntimeException("Invalid identifier in data in: " + this.getClass().getSimpleName());
        }
        this.validate();
    }

    ConcatInformationElement(int identifier, int mpRefNo, int mpMaxNo, int mpSeqNo) {
        byte[] data = null;
        switch (identifier) {
            case 0: {
                data = new byte[]{(byte)(mpRefNo & 0xFF), (byte)(mpMaxNo & 0xFF), (byte)(mpSeqNo & 0xFF)};
                break;
            }
            case 8: {
                data = new byte[]{(byte)((mpRefNo & 0xFF00) >>> 8), (byte)(mpRefNo & 0xFF), (byte)(mpMaxNo & 0xFF), (byte)(mpSeqNo & 0xFF)};
                break;
            }
            default: {
                throw new RuntimeException("Invalid identifier for " + this.getClass().getSimpleName());
            }
        }
        this.initialize((byte)(identifier & 0xFF), data);
        this.validate();
    }

    public int getMpRefNo() {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            return data[0] & 0xFF;
        }
        if (this.getIdentifier() == 8) {
            return (data[0] << 8 | data[1]) & 0xFFFF;
        }
        throw new RuntimeException("Invalid identifier");
    }

    public void setMpRefNo(int mpRefNo) {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            data[0] = (byte)(mpRefNo & 0xFF);
        } else if (this.getIdentifier() == 8) {
            data[0] = (byte)(mpRefNo >>> 8 & 0xFF);
            data[1] = (byte)(mpRefNo & 0xFF);
        } else {
            throw new RuntimeException("Invalid identifier");
        }
    }

    public int getMpMaxNo() {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            return data[1] & 0xFF;
        }
        if (this.getIdentifier() == 8) {
            return data[2] & 0xFF;
        }
        throw new RuntimeException("Invalid identifier");
    }

    public void setMpMaxNo(int mpMaxNo) {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            data[1] = (byte)(mpMaxNo & 0xFF);
        } else if (this.getIdentifier() == 8) {
            data[2] = (byte)(mpMaxNo & 0xFF);
        } else {
            throw new RuntimeException("Invalid identifier");
        }
    }

    public int getMpSeqNo() {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            return data[2] & 0xFF;
        }
        if (this.getIdentifier() == 8) {
            return data[3] & 0xFF;
        }
        throw new RuntimeException("Invalid identifier");
    }

    public void setMpSeqNo(int mpSeqNo) {
        byte[] data = this.getData();
        if (this.getIdentifier() == 0) {
            data[2] = (byte)(mpSeqNo & 0xFF);
        } else if (this.getIdentifier() == 8) {
            data[3] = (byte)(mpSeqNo & 0xFF);
        } else {
            throw new RuntimeException("Invalid identifier");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[MpRefNo: ");
        sb.append(this.getMpRefNo());
        sb.append(", MpMaxNo: ");
        sb.append(this.getMpMaxNo());
        sb.append(", MpSeqNo: ");
        sb.append(this.getMpSeqNo());
        sb.append("]");
        return sb.toString();
    }

    private void validate() {
        if (this.getMpRefNo() == 0) {
            throw new RuntimeException("mpRefNo must be > 0");
        }
        if (this.getMpMaxNo() == 0) {
            throw new RuntimeException("mpMaxNo must be > 0");
        }
        if (this.getMpSeqNo() == 0) {
            throw new RuntimeException("mpSeqNo must be > 0");
        }
    }
}

