/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduUtils;

public class SmsStatusReportPdu
extends Pdu {
    private int messageReference = 0;
    private int status = 0;
    private Date timestamp;
    private Date dischargeTime;

    SmsStatusReportPdu() {
    }

    public void setTpMms(int value) {
        this.checkTpMti(new int[]{0, 2});
        this.setFirstOctetField(251, value, new int[]{4, 0});
    }

    public boolean hasTpMms() {
        this.checkTpMti(new int[]{0, 2});
        return this.getFirstOctetField(251) == 4;
    }

    public void setTpSri(int value) {
        this.setFirstOctetField(223, value, new int[]{0, 32});
    }

    public boolean hasTpSri() {
        return this.getFirstOctetField(223) == 32;
    }

    public void setMessageReference(int reference) {
        this.messageReference = reference;
    }

    public int getMessageReference() {
        return this.messageReference;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setDischargeTime(Date dischargeTime) {
        this.dischargeTime = dischargeTime;
    }

    public Date getDischargeTime() {
        return this.dischargeTime;
    }

    protected String pduSubclassInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Reference: " + PduUtils.byteToPdu(this.getMessageReference()));
        sb.append("\n");
        sb.append("Destination Address: [Length: " + this.getAddress().length() + " (" + PduUtils.byteToPdu((byte)this.getAddress().length()) + ")");
        sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
        sb.append(", Address: " + this.getAddress());
        sb.append("]");
        sb.append("\n");
        sb.append("TP-SCTS: " + this.getTimestamp());
        sb.append("\n");
        sb.append("Discharge Time: " + this.getDischargeTime());
        sb.append("\n");
        sb.append("Status: " + PduUtils.byteToPdu(this.getStatus()));
        sb.append("\n");
        return sb.toString();
    }
}

