/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.BitSet;
import org.ajwcc.pduUtils.gsm3040.Pdu;

public class PduUtils {
    private static final char[][] grcAlphabetRemapping = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    private static final char[] extAlphabet = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
    private static final String[] extBytes = new String[]{"1b0a", "1b14", "1b28", "1b29", "1b2f", "1b3c", "1b3d", "1b3e", "1b40", "1b65"};
    private static final char[] stdAlphabet = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00e7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    public static final int TP_MTI_MASK = 252;
    public static final int TP_MTI_SMS_DELIVER = 0;
    public static final int TP_MTI_SMS_SUBMIT = 1;
    public static final int TP_MTI_SMS_STATUS_REPORT = 2;
    public static final int TP_RD_MASK = 251;
    public static final int TP_RD_ACCEPT_DUPLICATES = 0;
    public static final int TP_RD_REJECT_DUPLICATES = 4;
    public static final int TP_MMS_MASK = 251;
    public static final int TP_MMS_NO_MESSAGES = 0;
    public static final int TP_MMS_MORE_MESSAGES = 4;
    public static final int TP_VPF_MASK = 231;
    public static final int TP_VPF_NONE = 0;
    public static final int TP_VPF_INTEGER = 16;
    public static final int TP_VPF_TIMESTAMP = 24;
    public static final int TP_SRI_MASK = 223;
    public static final int TP_SRI_NO_REPORT = 0;
    public static final int TP_SRI_REPORT = 32;
    public static final int TP_SRR_MASK = 223;
    public static final int TP_SRR_NO_REPORT = 0;
    public static final int TP_SRR_REPORT = 32;
    public static final int TP_UDHI_MASK = 191;
    public static final int TP_UDHI_NO_UDH = 0;
    public static final int TP_UDHI_WITH_UDH = 64;
    public static final int ADDRESS_NUMBER_PLAN_ID_MASK = 15;
    public static final int ADDRESS_NUMBER_PLAN_ID_UNKNOWN = 0;
    public static final int ADDRESS_NUMBER_PLAN_ID_TELEPHONE = 1;
    public static final int ADDRESS_TYPE_MASK = 112;
    public static final int ADDRESS_TYPE_UNKNOWN = 0;
    public static final int ADDRESS_TYPE_INTERNATIONAL = 16;
    public static final int ADDRESS_TYPE_ALPHANUMERIC = 80;
    public static final int DCS_CODING_GROUP_MASK = 15;
    public static final int DCS_CODING_GROUP_DATA = 240;
    public static final int DCS_CODING_GROUP_GENERAL = 192;
    public static final int DCS_ENCODING_MASK = 243;
    public static final int DCS_ENCODING_7BIT = 0;
    public static final int DCS_ENCODING_8BIT = 4;
    public static final int DCS_ENCODING_UCS2 = 8;
    public static final int DCS_MESSAGE_CLASS_MASK = 236;
    public static final int DCS_MESSAGE_CLASS_FLASH = 16;

    public static int getAddressTypeFor(String address) {
        if (address.startsWith("+")) {
            address = address.substring(1);
        }
        for (int i = 0; i < address.length(); ++i) {
            if (Character.isDigit(address.charAt(i))) continue;
            return PduUtils.createAddressType(80);
        }
        if (address.length() == 12) {
            return PduUtils.createAddressType(17);
        }
        return PduUtils.createAddressType(1);
    }

    public static int extractAddressType(int addressType) {
        return addressType & 0x70;
    }

    public static int extractNumberPlan(int addressType) {
        return addressType & 0xF;
    }

    public static int createAddressType(int addressType) {
        return 0x80 | addressType;
    }

    public static int extractDcsEncoding(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFF0C;
    }

    public static int extractDcsFlash(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFF13;
    }

    public static int extractDcsCodingGroup(int dataCodingScheme) {
        return dataCodingScheme & 0xFFFFFFF0;
    }

    private static Integer getTpField(Pdu pdu, String fieldName) {
        try {
            Method m = pdu.getClass().getMethod("get" + fieldName, new Class[0]);
            return (Integer)m.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean hasTpField(Pdu pdu, String fieldName) {
        try {
            Method m = pdu.getClass().getMethod("has" + fieldName, new Class[0]);
            return (Boolean)m.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decodeFirstOctet(Pdu pdu) {
        StringBuffer sb = new StringBuffer();
        sb.append("First Octet: " + PduUtils.byteToPdu(pdu.getFirstOctet()));
        sb.append(" [");
        switch (pdu.getTpMti()) {
            case 0: {
                sb.append("TP-MTI: (SMS-DELIVER)");
                break;
            }
            case 2: {
                sb.append("TP-MTI: (SMS-STATUS REPORT)");
                break;
            }
            case 1: {
                sb.append("TP-MTI: (SMS-SUBMIT)");
                break;
            }
            default: {
                throw new RuntimeException("Invalid message type");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpMms") != null) {
            if (PduUtils.hasTpField(pdu, "TpMms").booleanValue()) {
                sb.append(", TP-MMS: (Has more messages)");
            } else {
                sb.append(", TP-MMS: (has no messages)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpRd") != null) {
            if (PduUtils.hasTpField(pdu, "TpRd").booleanValue()) {
                sb.append(", TP-RD: (Reject duplicates)");
            } else {
                sb.append(", TP-RD: (allow duplicates)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpVpf") != null && PduUtils.hasTpField(pdu, "TpVpf").booleanValue()) {
            switch (PduUtils.getTpField(pdu, "TpVpf")) {
                case 16: {
                    sb.append(", TP-VPF: (validity format, integer");
                    break;
                }
                case 24: {
                    sb.append(", TP-VPF: (validity format, timestamp");
                    break;
                }
                case 0: {
                    sb.append(", TP-VPF: (validity format, none)");
                }
            }
        }
        if (PduUtils.hasTpField(pdu, "TpSri") != null) {
            if (PduUtils.hasTpField(pdu, "TpSri").booleanValue()) {
                sb.append(", TP-SRI: (Requests Status Report)");
            } else {
                sb.append(", TP-SRI: (No Status Report)");
            }
        }
        if (PduUtils.hasTpField(pdu, "TpSrr") != null) {
            if (PduUtils.hasTpField(pdu, "TpSrr").booleanValue()) {
                sb.append(", TP-SRR: (Requests Status Report)");
            } else {
                sb.append(", TP-SRR: (No Status Report)");
            }
        }
        if (pdu.hasTpUdhi()) {
            sb.append(", TP-UDHI: (has UDH)");
        } else {
            sb.append(", TP-UDHI: (no UDH)");
        }
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }

    public static String decodeDataCodingScheme(Pdu pdu) {
        StringBuffer sb = new StringBuffer();
        switch (PduUtils.extractDcsEncoding(pdu.getDataCodingScheme())) {
            case 0: {
                sb.append("7-bit GSM Alphabet");
                break;
            }
            case 4: {
                sb.append("8-bit encoding");
                break;
            }
            case 8: {
                sb.append("UCS2 encoding");
            }
        }
        if ((pdu.getDataCodingScheme() & 0xFFFFFF3F) == 0 && PduUtils.extractDcsFlash(pdu.getDataCodingScheme()) == 16) {
            sb.append(", (Flash Message)");
        }
        return sb.toString();
    }

    public static byte[] encode8bitUserData(String text) {
        try {
            return text.getBytes("ISO8859_1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeUcs2UserData(String text) {
        try {
            return text.getBytes("UTF-16BE");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encode7bitUserData(byte[] udhOctets, byte[] textSeptets) {
        if (udhOctets == null) {
            return PduUtils.unencodedSeptetsToEncodedSeptets(textSeptets);
        }
        byte[] udhSeptets = PduUtils.encodedSeptetsToUnencodedSeptets(udhOctets, false);
        byte[] combined = new byte[udhSeptets.length + textSeptets.length];
        System.arraycopy(udhSeptets, 0, combined, 0, udhSeptets.length);
        System.arraycopy(textSeptets, 0, combined, udhSeptets.length, textSeptets.length);
        return PduUtils.unencodedSeptetsToEncodedSeptets(combined);
    }

    public static String decode7bitEncoding(byte[] encodedPduData) {
        return PduUtils.decode7bitEncoding(0, encodedPduData);
    }

    public static String decode7bitEncoding(int udhLength, byte[] encodedPduData) {
        if (udhLength == 0) {
            return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedPduData));
        }
        int udhSeptets = PduUtils.getNumSeptetsForOctets(udhLength);
        return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedPduData)).substring(udhSeptets);
    }

    public static String decode8bitEncoding(int udhLength, byte[] pduData) {
        try {
            return new String(pduData, udhLength, pduData.length - udhLength, "ISO8859_1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeUcs2Encoding(int udhLength, byte[] pduData) {
        try {
            return new String(pduData, udhLength, pduData.length - udhLength, "UTF-16");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte swapNibbles(int b) {
        return (byte)(b << 4 & 0xF0 | b >>> 4 & 0xF);
    }

    public static String readBCDNumbers(int numDigits, byte[] addressData) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < addressData.length; ++i) {
            byte b = addressData[i];
            int num1 = b & 0xF;
            sb.append(num1);
            int num2 = b >>> 4 & 0xF;
            if (num2 == 15) continue;
            sb.append(num2);
        }
        return sb.toString();
    }

    public static int createSwappedBCD(int decimal) {
        int tens = (decimal & 0xFF) / 10;
        int ones = (decimal & 0xFF) - tens * 10;
        return ones << 4 | tens;
    }

    public static String stringToPdu(String txt) {
        byte[] txtBytes = PduUtils.stringToUnencodedSeptets(txt);
        return PduUtils.bytesToPdu(PduUtils.unencodedSeptetsToEncodedSeptets(txtBytes));
    }

    public static byte[] stringToUnencodedSeptets(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int k = 0;
        block0: for (int i = 0; i < s.length(); ++i) {
            int j;
            char ch = s.charAt(i);
            int index = -1;
            for (j = 0; j < extAlphabet.length; ++j) {
                if (extAlphabet[j] != ch) continue;
                index = j;
                break;
            }
            if (index != -1) {
                baos.write((byte)Integer.parseInt(extBytes[index].substring(0, 2), 16));
                ++k;
                baos.write((byte)Integer.parseInt(extBytes[index].substring(2, 4), 16));
                ++k;
                continue;
            }
            index = -1;
            for (j = 0; j < stdAlphabet.length; ++j) {
                if (stdAlphabet[j] != ch) continue;
                index = j;
                baos.write((byte)j);
                ++k;
                break;
            }
            if (index != -1) continue;
            for (j = 0; j < grcAlphabetRemapping.length; ++j) {
                if (grcAlphabetRemapping[j][0] != ch) continue;
                index = j;
                ch = grcAlphabetRemapping[j][1];
                break;
            }
            if (index != -1) {
                for (j = 0; j < stdAlphabet.length; ++j) {
                    if (stdAlphabet[j] != ch) continue;
                    index = j;
                    baos.write((byte)j);
                    ++k;
                    continue block0;
                }
                continue;
            }
            baos.write(32);
            ++k;
        }
        return baos.toByteArray();
    }

    public static byte[] unencodedSeptetsToEncodedSeptets(byte[] septetBytes) {
        int j;
        int i;
        byte[] txtBytes = septetBytes;
        int txtBytesLen = txtBytes.length;
        BitSet bits = new BitSet();
        for (i = 0; i < txtBytesLen; ++i) {
            for (j = 0; j < 7; ++j) {
                if ((txtBytes[i] & 1 << j) == 0) continue;
                bits.set(i * 7 + j);
            }
        }
        int encodedSeptetByteArrayLength = txtBytesLen * 7 / 8 + (txtBytesLen * 7 % 8 != 0 ? 1 : 0);
        byte[] txtSeptets = new byte[encodedSeptetByteArrayLength];
        for (i = 0; i < encodedSeptetByteArrayLength; ++i) {
            for (j = 0; j < 8; ++j) {
                int n = i;
                txtSeptets[n] = (byte)(txtSeptets[n] | (byte)((bits.get(i * 8 + j) ? 1 : 0) << j));
            }
        }
        return txtSeptets;
    }

    public static String unencodedSeptetsToString(byte[] bytes) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 27) {
                String extChar = "1b" + Integer.toHexString(bytes[++i]);
                for (int j = 0; j < extBytes.length; ++j) {
                    if (!extBytes[j].equalsIgnoreCase(extChar)) continue;
                    text.append(extAlphabet[j]);
                }
                continue;
            }
            text.append(stdAlphabet[bytes[i]]);
        }
        return text.toString();
    }

    public static String encodedSeptetsToString(byte[] encodedSeptets) {
        return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(encodedSeptets));
    }

    public static int getNumSeptetsForOctets(int numOctets) {
        return numOctets * 8 / 7 + (numOctets * 8 % 7 != 0 ? 1 : 0);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] octetBytes) {
        return PduUtils.encodedSeptetsToUnencodedSeptets(octetBytes, true);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] octetBytes, boolean discardLast) {
        int value2;
        int j;
        int i;
        BitSet bitSet = new BitSet(octetBytes.length * 8);
        int value1 = 0;
        for (i = 0; i < octetBytes.length; ++i) {
            for (j = 0; j < 8; ++j) {
                value1 = i * 8 + j;
                if ((octetBytes[i] & 1 << j) == 0) continue;
                bitSet.set(value1);
            }
        }
        if ((value2 = ++value1 / 7 + (value1 % 7 != 0 ? 1 : 0)) == 0) {
            ++value2;
        }
        byte[] newBytes = new byte[value2];
        for (i = 0; i < value2; ++i) {
            for (j = 0; j < 7; ++j) {
                if (value1 + 1 <= i * 7 + j || !bitSet.get(i * 7 + j)) continue;
                int n = i;
                newBytes[n] = (byte)(newBytes[n] | (byte)(1 << j));
            }
        }
        if (discardLast && newBytes[newBytes.length - 1] == 0) {
            byte[] retVal = new byte[newBytes.length - 1];
            System.arraycopy(newBytes, 0, retVal, 0, retVal.length);
            return retVal;
        }
        return newBytes;
    }

    public static byte[] pduToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            bytes[i / 2] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
        }
        return bytes;
    }

    public static String pduToBits(String pduString) {
        return PduUtils.bytesToBits(PduUtils.pduToBytes(pduString));
    }

    public static String bytesToPdu(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(PduUtils.byteToPdu(bytes[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String bytesToBits(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String bits = Integer.toBinaryString(b[i] & 0xFF);
            while (bits.length() < 8) {
                bits = "0" + bits;
            }
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(bits);
        }
        return sb.toString();
    }

    public static String byteToBits(byte b) {
        String bits = Integer.toBinaryString(b & 0xFF);
        while (bits.length() < 8) {
            bits = "0" + bits;
        }
        return bits;
    }

    public static String byteToPdu(int b) {
        StringBuffer sb = new StringBuffer();
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        return sb.toString().toUpperCase();
    }
}

