/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import org.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import org.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import org.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PduGenerator {
    private ByteArrayOutputStream baos;
    private int firstOctetPosition = -1;
    private boolean updateFirstOctet = false;

    protected void writeSmscInfo(Pdu pdu) throws Exception {
        if (pdu.getSmscAddress() != null) {
            this.writeBCDAddress(pdu.getSmscAddress(), pdu.getSmscAddressType(), pdu.getSmscInfoLength());
        } else {
            this.writeByte(0);
        }
    }

    protected void writeFirstOctet(Pdu pdu) {
        this.firstOctetPosition = pdu.getSmscInfoLength() + 1;
        this.writeByte(pdu.getFirstOctet());
    }

    protected void writeValidityPeriodInteger(int validityPeriod) {
        if (validityPeriod == -1) {
            this.baos.write(255);
        } else {
            int validityInt = validityPeriod <= 12 ? validityPeriod * 12 - 1 : (validityPeriod <= 24 ? (validityPeriod - 12) * 2 + 143 : (validityPeriod <= 720 ? validityPeriod / 24 + 166 : validityPeriod / 168 + 192));
            this.baos.write(validityInt);
        }
    }

    protected void writeTimeStampStringForDate(Date timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        int year = cal.get(1) - 2000;
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minute = cal.get(12);
        int sec = cal.get(13);
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(timestamp.getTime());
        int minOffset = offset / 60000;
        int tzValue = minOffset / 15;
        if (tzValue < 0) {
            tzValue = 128 - tzValue;
        }
        this.baos.write(PduUtils.createSwappedBCD(year));
        this.baos.write(PduUtils.createSwappedBCD(month));
        this.baos.write(PduUtils.createSwappedBCD(dayOfMonth));
        this.baos.write(PduUtils.createSwappedBCD(hourOfDay));
        this.baos.write(PduUtils.createSwappedBCD(minute));
        this.baos.write(PduUtils.createSwappedBCD(sec));
        this.baos.write(PduUtils.createSwappedBCD(tzValue));
    }

    protected void writeAddress(String address, int addressType, int addressLength) throws Exception {
        switch (PduUtils.extractAddressType(addressType)) {
            case 80: {
                byte[] textSeptets = PduUtils.stringToUnencodedSeptets(address);
                byte[] alphaNumBytes = PduUtils.encode7bitUserData(null, textSeptets);
                this.baos.write(alphaNumBytes.length * 2);
                this.baos.write(addressType);
                this.baos.write(alphaNumBytes);
                break;
            }
            default: {
                this.writeBCDAddress(address, addressType, addressLength);
            }
        }
    }

    protected void writeBCDAddress(String address, int addressType, int addressLength) throws Exception {
        this.baos.write(addressLength);
        this.baos.write(addressType);
        if (address.length() % 2 == 1) {
            address = address + "F";
        }
        int digit = 0;
        for (int i = 0; i < address.length(); ++i) {
            char c = address.charAt(i);
            if (i % 2 == 1) {
                this.baos.write(digit |= Integer.parseInt(Character.toString(c), 16) << 4);
                digit = 0;
                continue;
            }
            digit |= Integer.parseInt(Character.toString(c), 16) & 0xF;
        }
    }

    protected void writeUDData(Pdu pdu, int mpRefNo, int partNo) {
        int dcs = pdu.getDataCodingScheme();
        try {
            switch (PduUtils.extractDcsEncoding(dcs)) {
                case 0: {
                    this.writeUDData7bit(pdu, mpRefNo, partNo);
                    break;
                }
                case 4: {
                    this.writeUDData8bit(pdu, mpRefNo, partNo);
                    break;
                }
                case 8: {
                    this.writeUDDataUCS2(pdu, mpRefNo, partNo);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid DCS encoding: " + PduUtils.extractDcsEncoding(dcs));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeUDH(Pdu pdu) throws IOException {
        this.writeUDH(pdu, this.baos);
    }

    protected void writeUDH(Pdu pdu, ByteArrayOutputStream udhBaos) throws IOException {
        udhBaos.write(pdu.getUDHLength());
        Iterator<InformationElement> ieIterator = pdu.getInformationElements();
        while (ieIterator.hasNext()) {
            InformationElement ie = ieIterator.next();
            udhBaos.write(ie.getIdentifier());
            udhBaos.write(ie.getLength());
            udhBaos.write(ie.getData());
        }
    }

    protected int computeOffset(Pdu pdu, int maxMessageLength, int partNo) {
        int offset;
        int maxParts = 1;
        maxParts = !pdu.isBinary() ? pdu.getDecodedText().length() / maxMessageLength + 1 : pdu.getDataBytes().length / maxMessageLength + 1;
        if (pdu.hasTpUdhi() && pdu.getConcatInfo() != null && partNo > 0) {
            pdu.getConcatInfo().setMpMaxNo(maxParts);
        }
        if (maxParts > 1 && partNo > 0) {
            if (partNo > maxParts) {
                throw new RuntimeException("Invalid partNo: " + partNo + ", maxParts=" + maxParts);
            }
            offset = (partNo - 1) * maxMessageLength;
        } else {
            offset = 0;
        }
        return offset;
    }

    protected void checkForConcat(Pdu pdu, int lengthOfText, int maxLength, int maxLengthWithUdh, int mpRefNo, int partNo) {
        if (lengthOfText > maxLengthWithUdh && (lengthOfText <= maxLengthWithUdh || lengthOfText > maxLength)) {
            if (pdu.getConcatInfo() != null) {
                pdu.getConcatInfo().setMpRefNo(mpRefNo);
                pdu.getConcatInfo().setMpSeqNo(partNo);
            } else {
                ConcatInformationElement concatInfo = InformationElementFactory.generateConcatInfo(mpRefNo, partNo);
                pdu.addInformationElement(concatInfo);
                this.updateFirstOctet = true;
            }
        }
    }

    protected int computePotentialUdhLength(Pdu pdu) {
        int currentUdhLength = pdu.getTotalUDHLength();
        if (currentUdhLength == 0) {
            return ConcatInformationElement.getDefaultConcatLength() + 1;
        }
        return currentUdhLength + ConcatInformationElement.getDefaultConcatLength();
    }

    protected void writeUDData7bit(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        String decodedText = pdu.getDecodedText();
        byte[] textSeptetsForDecodedText = PduUtils.stringToUnencodedSeptets(decodedText);
        int potentialUdhLength = PduUtils.getNumSeptetsForOctets(this.computePotentialUdhLength(pdu));
        this.checkForConcat(pdu, textSeptetsForDecodedText.length, 160, 160 - potentialUdhLength, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = 160 - PduUtils.getNumSeptetsForOctets(totalUDHLength);
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        String textToEncode = decodedText.substring(offset, Math.min(offset + maxMessageLength, decodedText.length()));
        byte[] textSeptets = PduUtils.stringToUnencodedSeptets(textToEncode);
        int udLength = PduUtils.getNumSeptetsForOctets(totalUDHLength) + textSeptets.length;
        this.baos.write(udLength);
        byte[] udhBytes = null;
        if (pdu.hasTpUdhi()) {
            ByteArrayOutputStream udhBaos = new ByteArrayOutputStream();
            this.writeUDH(pdu, udhBaos);
            udhBytes = udhBaos.toByteArray();
        }
        byte[] udBytes = PduUtils.encode7bitUserData(udhBytes, textSeptets);
        this.baos.write(udBytes);
    }

    protected void writeUDData8bit(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        byte[] data = pdu.isBinary() ? pdu.getDataBytes() : PduUtils.encode8bitUserData(pdu.getDecodedText());
        int potentialUdhLength = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, data.length, 140, 140 - potentialUdhLength, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = 140 - totalUDHLength;
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        byte[] dataToWrite = new byte[Math.min(maxMessageLength, data.length - offset)];
        System.arraycopy(data, offset, dataToWrite, 0, dataToWrite.length);
        int udLength = totalUDHLength + dataToWrite.length;
        this.baos.write(udLength);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this.baos);
        }
        this.baos.write(dataToWrite);
    }

    protected void writeUDDataUCS2(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        String decodedText = pdu.getDecodedText();
        int potentialUdhLength = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, decodedText.length(), 70, (140 - potentialUdhLength) / 2, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = (140 - totalUDHLength) / 2;
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        String textToEncode = decodedText.substring(offset, Math.min(offset + maxMessageLength, decodedText.length()));
        int udLength = totalUDHLength + textToEncode.length() * 2;
        this.baos.write(udLength);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this.baos);
        }
        this.baos.write(PduUtils.encodeUcs2UserData(textToEncode));
    }

    protected void writeByte(int i) {
        this.baos.write(i);
    }

    protected void writeBytes(byte[] b) throws Exception {
        this.baos.write(b);
    }

    public List<String> generatePduList(Pdu pdu, int mpRefNo) {
        ArrayList<String> pduList = new ArrayList<String>();
        for (int i = 1; i <= pdu.getMpMaxNo(); ++i) {
            String pduString = this.generatePduString(pdu, mpRefNo, i);
            pduList.add(pduString);
        }
        return pduList;
    }

    public String generatePduString(Pdu pdu) {
        return this.generatePduString(pdu, -1, -1);
    }

    public String generatePduString(Pdu pdu, int mpRefNo, int partNo) {
        try {
            this.baos = new ByteArrayOutputStream();
            this.firstOctetPosition = -1;
            this.updateFirstOctet = false;
            switch (pdu.getTpMti()) {
                case 0: {
                    this.generateSmsDeliverPduString((SmsDeliveryPdu)pdu, mpRefNo, partNo);
                    break;
                }
                case 1: {
                    this.generateSmsSubmitPduString((SmsSubmitPdu)pdu, mpRefNo, partNo);
                    break;
                }
                case 2: {
                    this.generateSmsStatusReportPduString((SmsStatusReportPdu)pdu);
                }
            }
            byte[] pduBytes = this.baos.toByteArray();
            if (this.updateFirstOctet) {
                pduBytes[this.firstOctetPosition] = (byte)(pdu.getFirstOctet() & 0xFF);
            }
            return PduUtils.bytesToPdu(pduBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void generateSmsSubmitPduString(SmsSubmitPdu pdu, int mpRefNo, int partNo) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeByte(pdu.getMessageReference());
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeByte(pdu.getProtocolIdentifier());
        this.writeByte(pdu.getDataCodingScheme());
        switch (pdu.getTpVpf()) {
            case 16: {
                this.writeValidityPeriodInteger(pdu.getValidityPeriod());
                break;
            }
            case 24: {
                this.writeTimeStampStringForDate(pdu.getValidityDate());
            }
        }
        this.writeUDData(pdu, mpRefNo, partNo);
    }

    protected void generateSmsDeliverPduString(SmsDeliveryPdu pdu, int mpRefNo, int partNo) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeByte(pdu.getProtocolIdentifier());
        this.writeByte(pdu.getDataCodingScheme());
        this.writeTimeStampStringForDate(pdu.getTimestamp());
        this.writeUDData(pdu, mpRefNo, partNo);
    }

    protected void generateSmsStatusReportPduString(SmsStatusReportPdu pdu) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeByte(pdu.getMessageReference());
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeTimeStampStringForDate(pdu.getTimestamp());
        this.writeTimeStampStringForDate(pdu.getDischargeTime());
        this.writeByte(pdu.getStatus());
    }
}

