/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import org.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import org.ajwcc.pduUtils.gsm3040.ie.PortInformationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pdu {
    private int smscInfoLength;
    private int smscAddressType;
    private String smscAddress;
    private int firstOctet = 0;
    private int protocolIdentifier = 0;
    private int dataCodingScheme = 0;
    private int addressType;
    private String address;
    private int udLength;
    private byte[] udData;
    private static final int UDH_CHECK_MODE_ADD_IF_NONE = 0;
    private static final int UDH_CHECK_MODE_EXCEPTION_IF_NONE = 1;
    private static final int UDH_CHECK_MODE_IGNORE_IF_NONE = 2;
    private HashMap<Integer, InformationElement> ieMap = new HashMap();
    private ArrayList<InformationElement> ieList = new ArrayList();
    private String decodedText;
    private byte[] dataBytes;
    private String rawPdu;

    public int getSmscInfoLength() {
        return this.smscInfoLength;
    }

    public void setSmscInfoLength(int smscInfoLength) {
        this.smscInfoLength = smscInfoLength;
    }

    public void setSmscAddressType(int smscAddressType) {
        this.smscAddressType = PduUtils.createAddressType(smscAddressType);
    }

    public int getSmscAddressType() {
        return this.smscAddressType;
    }

    public void setSmscAddress(String smscAddress) {
        if (smscAddress.equals("")) {
            smscAddress = null;
            this.smscAddressType = 0;
            this.smscInfoLength = 0;
            return;
        }
        if (smscAddress.startsWith("+")) {
            smscAddress = smscAddress.substring(1);
        }
        this.smscAddress = smscAddress;
        this.setSmscAddressType(PduUtils.getAddressTypeFor(smscAddress));
    }

    public String getSmscAddress() {
        return this.smscAddress;
    }

    public int getFirstOctet() {
        return this.firstOctet;
    }

    public void setFirstOctet(int value) {
        this.firstOctet = value;
    }

    protected void setFirstOctetField(int fieldName, int fieldValue, int[] allowedValues) {
        for (int value : allowedValues) {
            if (value != fieldValue) continue;
            this.firstOctet &= fieldName;
            this.firstOctet |= fieldValue;
            return;
        }
        throw new RuntimeException("Invalid value for fieldName.");
    }

    protected int getFirstOctetField(int fieldName) {
        return this.firstOctet & ~fieldName;
    }

    protected void checkTpMti(int allowedType) {
        int tpMti = this.getTpMti();
        if (tpMti != allowedType) {
            throw new RuntimeException("Invalid message type : " + this.getTpMti());
        }
    }

    protected void checkTpMti(int[] allowedTypes) {
        int tpMti = this.getTpMti();
        for (int type : allowedTypes) {
            if (tpMti != type) continue;
            return;
        }
        throw new RuntimeException("Invalid message type : " + this.getTpMti());
    }

    public void setTpMti(int value) {
        this.setFirstOctetField(252, value, new int[]{0, 2, 1});
    }

    public int getTpMti() {
        return this.getFirstOctetField(252);
    }

    public void setTpUdhi(int value) {
        this.setFirstOctetField(191, value, new int[]{0, 64});
    }

    public boolean hasTpUdhi() {
        return this.getFirstOctetField(191) == 64;
    }

    public void setProtocolIdentifier(int protocolIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
    }

    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public void setDataCodingScheme(int encoding) {
        switch (encoding & 0xFFFFFF0C) {
            case 0: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding value: " + PduUtils.byteToPdu(encoding));
            }
        }
        this.dataCodingScheme = encoding;
    }

    public int getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = PduUtils.createAddressType(addressType);
    }

    public void setAddress(String address) {
        if (address.startsWith("+")) {
            address = address.substring(1);
        }
        this.address = address;
        this.setAddressType(PduUtils.getAddressTypeFor(address));
    }

    public String getAddress() {
        return this.address;
    }

    public int getUDLength() {
        return this.udLength;
    }

    public void setUDLength(int udLength) {
        this.udLength = udLength;
    }

    public byte[] getUDData() {
        return this.udData;
    }

    public void setUDData(byte[] udData) {
        this.udData = udData;
    }

    private void checkForUDHI(int udhCheckMode) {
        if (!this.hasTpUdhi()) {
            switch (udhCheckMode) {
                case 1: {
                    throw new IllegalStateException("PDU does not have a UDHI in the first octet");
                }
                case 0: {
                    this.setTpUdhi(64);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid UDH check mode");
                }
            }
        }
    }

    public int getTotalUDHLength() {
        int udhLength = this.getUDHLength();
        if (udhLength == 0) {
            return 0;
        }
        return udhLength + 1;
    }

    public int getUDHLength() {
        int udhLength = 0;
        for (InformationElement ie : this.ieMap.values()) {
            udhLength = udhLength + ie.getLength() + 2;
        }
        return udhLength;
    }

    public byte[] getUDHData() {
        this.checkForUDHI(2);
        int totalUdhLength = this.getTotalUDHLength();
        if (totalUdhLength == 0) {
            return null;
        }
        byte[] retVal = new byte[totalUdhLength];
        System.arraycopy(this.udData, 0, retVal, 0, totalUdhLength);
        return retVal;
    }

    public void addInformationElement(InformationElement ie) {
        this.checkForUDHI(0);
        this.ieMap.put(ie.getIdentifier(), ie);
        this.ieList.add(ie);
    }

    public InformationElement getInformationElement(int iei) {
        this.checkForUDHI(2);
        return this.ieMap.get(iei);
    }

    public Iterator<InformationElement> getInformationElements() {
        this.checkForUDHI(2);
        return this.ieList.iterator();
    }

    public boolean isConcatMessage() {
        return this.getConcatInfo() != null;
    }

    public ConcatInformationElement getConcatInfo() {
        this.checkForUDHI(2);
        ConcatInformationElement concat = (ConcatInformationElement)this.getInformationElement(0);
        if (concat == null) {
            concat = (ConcatInformationElement)this.getInformationElement(8);
        }
        return concat;
    }

    public int getMpRefNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpRefNo();
        }
        return 0;
    }

    public int getMpMaxNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpMaxNo();
        }
        return 1;
    }

    public int getMpSeqNo() {
        ConcatInformationElement concat = this.getConcatInfo();
        if (concat != null) {
            return concat.getMpSeqNo();
        }
        return 0;
    }

    public boolean isPortedMessage() {
        return this.getPortInfo() != null;
    }

    private PortInformationElement getPortInfo() {
        this.checkForUDHI(2);
        return (PortInformationElement)this.getInformationElement(5);
    }

    public int getDestPort() {
        PortInformationElement portIe = this.getPortInfo();
        if (portIe == null) {
            return -1;
        }
        return portIe.getDestPort();
    }

    public int getSrcPort() {
        PortInformationElement portIe = this.getPortInfo();
        if (portIe == null) {
            return -1;
        }
        return portIe.getSrcPort();
    }

    public void setDataBytes(byte[] dataBytes) {
        this.dataBytes = dataBytes;
        this.decodedText = null;
        this.dataCodingScheme &= 0xF3;
        this.dataCodingScheme |= 4;
        this.dataCodingScheme |= 0xF0;
    }

    public byte[] getDataBytes() {
        return this.dataBytes;
    }

    public boolean isBinary() {
        return (this.dataCodingScheme & 0xF0) == 240 || (this.dataCodingScheme & 4) == 4;
    }

    public void setDecodedText(String decodedText) {
        this.decodedText = decodedText;
        this.dataBytes = null;
        this.dataCodingScheme &= 0xF;
    }

    public String getDecodedText() {
        if (this.decodedText != null) {
            return this.decodedText;
        }
        if (this.udData == null) {
            throw new NullPointerException("No udData to decode");
        }
        try {
            return this.decodeNonUDHDataAsString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getUserDataAsBytes() {
        int remainingLength = this.udData.length - this.getTotalUDHLength();
        byte[] retVal = new byte[remainingLength];
        System.arraycopy(this.udData, this.getTotalUDHLength(), retVal, 0, remainingLength);
        return retVal;
    }

    private String decodeNonUDHDataAsString() {
        int udhTotalBytes = this.getTotalUDHLength();
        switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
            case 0: {
                return PduUtils.decode7bitEncoding(udhTotalBytes, this.udData);
            }
            case 4: {
                return PduUtils.decode8bitEncoding(udhTotalBytes, this.udData);
            }
            case 8: {
                return PduUtils.decodeUcs2Encoding(udhTotalBytes, this.udData);
            }
        }
        throw new RuntimeException("Invalid dataCodingScheme: " + this.getDataCodingScheme());
    }

    public String getRawPdu() {
        return this.rawPdu;
    }

    public void setRawPdu(String rawPdu) {
        this.rawPdu = rawPdu;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("=================================================\n");
        sb.append("<< " + this.getClass().getSimpleName() + " >>");
        sb.append("\n");
        sb.append("Raw Pdu: ");
        sb.append(this.rawPdu);
        sb.append("\n");
        sb.append("\n");
        if (this.smscAddress != null) {
            sb.append("SMSC Address: [Length: " + this.getSmscInfoLength() + " (" + PduUtils.byteToPdu((byte)this.getSmscInfoLength()) + ") octets");
            sb.append(", Type: " + PduUtils.byteToPdu(this.smscAddressType) + " (" + PduUtils.byteToBits((byte)this.smscAddressType) + ")");
            sb.append(", Address: " + this.smscAddress);
            sb.append("]");
        } else {
            sb.append("SMSC Address: [Length: 0 octets]");
        }
        sb.append("\n");
        sb.append(PduUtils.decodeFirstOctet(this));
        String subclassInfo = this.pduSubclassInfo();
        if (subclassInfo != null) {
            sb.append(subclassInfo);
        }
        sb.append("\n");
        if (this.udData != null) {
            switch (PduUtils.extractDcsEncoding(this.getDataCodingScheme())) {
                case 0: {
                    sb.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") septets");
                    sb.append("\n");
                    break;
                }
                case 4: 
                case 8: {
                    sb.append("User Data Length: " + this.getUDLength() + " (" + PduUtils.byteToPdu(this.getUDLength()) + ") octets");
                    sb.append("\n");
                }
            }
            sb.append("User Data (pdu) : " + PduUtils.bytesToPdu(this.getUDData()));
            sb.append("\n");
            if (this.hasTpUdhi()) {
                sb.append("User Data Header (pdu) : " + PduUtils.bytesToPdu(this.getUDHData()));
                sb.append("\n");
                int udhLength = this.getUDHLength();
                sb.append("User Data Header Length: " + udhLength + " (" + PduUtils.byteToPdu(udhLength) + ") octets");
                sb.append("\n");
                sb.append("\n");
                sb.append("UDH Information Elements:\n");
                for (InformationElement ie : this.ieMap.values()) {
                    sb.append(ie.toString());
                    sb.append("\n");
                }
                sb.append("\n");
                sb.append("Non UDH Data (pdu)    : " + PduUtils.bytesToPdu(this.getUserDataAsBytes()));
                sb.append("\n");
                if (!this.isBinary()) {
                    sb.append("Non UDH Data (decoded): [" + this.getDecodedText() + "]");
                    sb.append("\n");
                }
            } else if (!this.isBinary()) {
                sb.append("User Data (decoded): [" + this.getDecodedText() + "]");
                sb.append("\n");
            }
        }
        sb.append("=================================================\n");
        return sb.toString();
    }

    protected String pduSubclassInfo() {
        return null;
    }
}

